<?php $__env->startSection('title', 'Election Intelligence - Mews'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    :root {
        --npp-color: #0057B7;
        --ndc-color: #009739;
        --others-color: #808080;
    }

    .election-dashboard {
        min-height: 100vh;
        background: var(--bg-secondary);
        padding-bottom: 80px;
    }

    .election-header {
        background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
        padding: 20px 16px;
        color: white;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .election-header-content {
        max-width: 1200px;
        margin: 0 auto;
    }

    .election-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 4px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .election-title-icon {
        font-size: 1.2rem;
    }

    .election-subtitle {
        font-size: 0.85rem;
        opacity: 0.8;
    }

    .election-selector {
        display: flex;
        gap: 8px;
        margin-top: 16px;
        flex-wrap: wrap;
    }

    .election-select {
        background: rgba(255,255,255,0.1);
        border: 1px solid rgba(255,255,255,0.2);
        color: white;
        padding: 8px 12px;
        border-radius: 8px;
        font-size: 0.9rem;
        flex: 1;
        min-width: 120px;
    }

    .election-select option {
        background: #1a1a2e;
        color: white;
    }

    .dashboard-content {
        max-width: 1200px;
        margin: 0 auto;
        padding: 16px;
    }

    .widget {
        background: var(--bg-primary);
        border-radius: 16px;
        padding: 20px;
        margin-bottom: 16px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }

    .widget-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 16px;
    }

    .widget-title {
        font-size: 1rem;
        font-weight: 600;
        color: var(--text-primary);
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .widget-icon {
        font-size: 1.1rem;
    }

    .widget-action {
        font-size: 0.8rem;
        color: var(--accent-color);
        text-decoration: none;
    }

    /* Race Overview Widget */
    .race-overview {
        display: flex;
        justify-content: space-around;
        gap: 16px;
        flex-wrap: wrap;
    }

    .party-card {
        text-align: center;
        flex: 1;
        min-width: 80px;
        max-width: 120px;
    }

    .party-percentage {
        font-size: 2rem;
        font-weight: 700;
        line-height: 1;
    }

    .party-percentage.npp { color: var(--npp-color); }
    .party-percentage.ndc { color: var(--ndc-color); }
    .party-percentage.others { color: var(--others-color); }

    .party-name {
        font-size: 0.9rem;
        font-weight: 600;
        margin-top: 4px;
        color: var(--text-primary);
    }

    .party-bar {
        height: 8px;
        border-radius: 4px;
        margin-top: 8px;
        background: #e0e0e0;
        overflow: hidden;
    }

    .party-bar-fill {
        height: 100%;
        border-radius: 4px;
        transition: width 0.5s ease;
    }

    .party-bar-fill.npp { background: var(--npp-color); }
    .party-bar-fill.ndc { background: var(--ndc-color); }
    .party-bar-fill.others { background: var(--others-color); }

    .race-status {
        text-align: center;
        margin-top: 16px;
        padding-top: 16px;
        border-top: 1px solid var(--border-color);
    }

    .race-status-label {
        font-size: 0.75rem;
        color: var(--text-secondary);
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .race-status-value {
        font-size: 0.9rem;
        font-weight: 600;
        color: var(--text-primary);
        margin-top: 4px;
    }

    /* Poll Tracker Widget */
    .poll-item {
        padding: 12px 0;
        border-bottom: 1px solid var(--border-color);
    }

    .poll-item:last-child {
        border-bottom: none;
        padding-bottom: 0;
    }

    .poll-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 8px;
    }

    .poll-source {
        font-size: 0.85rem;
        font-weight: 600;
        color: var(--text-primary);
    }

    .poll-date {
        font-size: 0.75rem;
        color: var(--text-secondary);
    }

    .poll-results {
        display: flex;
        gap: 16px;
        margin-bottom: 4px;
    }

    .poll-result {
        font-size: 0.85rem;
    }

    .poll-result .party {
        font-weight: 600;
    }

    .poll-result .party.npp { color: var(--npp-color); }
    .poll-result .party.ndc { color: var(--ndc-color); }

    .poll-meta {
        font-size: 0.75rem;
        color: var(--text-secondary);
    }

    .add-poll-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        width: 100%;
        padding: 12px;
        margin-top: 12px;
        background: var(--bg-secondary);
        border: 2px dashed var(--border-color);
        border-radius: 8px;
        color: var(--text-secondary);
        font-size: 0.85rem;
        cursor: pointer;
        transition: all 0.2s;
    }

    .add-poll-btn:hover {
        border-color: var(--accent-color);
        color: var(--accent-color);
    }

    /* Social Sentiment Widget */
    .sentiment-unavailable {
        text-align: center;
        padding: 20px;
        color: var(--text-secondary);
    }

    .sentiment-unavailable-icon {
        font-size: 2rem;
        margin-bottom: 8px;
    }

    .sentiment-party {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 8px 0;
    }

    .sentiment-party-name {
        font-weight: 600;
        font-size: 0.9rem;
    }

    .sentiment-bar-container {
        flex: 1;
        margin: 0 12px;
        height: 24px;
        background: #f0f0f0;
        border-radius: 12px;
        overflow: hidden;
        display: flex;
    }

    .sentiment-positive {
        background: #22c55e;
        height: 100%;
    }

    .sentiment-neutral {
        background: #6b7280;
        height: 100%;
    }

    .sentiment-negative {
        background: #ef4444;
        height: 100%;
    }

    .sentiment-pct {
        font-size: 0.8rem;
        font-weight: 600;
        min-width: 40px;
        text-align: right;
    }

    /* AI Prediction Widget */
    .prediction-card {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 12px;
    }

    [data-theme="dark"] .prediction-card {
        background: linear-gradient(135deg, #2d2d2d 0%, #1f1f1f 100%);
    }

    .prediction-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 12px;
    }

    .prediction-party {
        font-weight: 700;
        font-size: 1.1rem;
    }

    .prediction-party.npp { color: var(--npp-color); }
    .prediction-party.ndc { color: var(--ndc-color); }

    .prediction-probability {
        font-size: 1.5rem;
        font-weight: 700;
    }

    .prediction-analysis {
        font-size: 0.85rem;
        color: var(--text-secondary);
        line-height: 1.5;
        margin-top: 12px;
        padding-top: 12px;
        border-top: 1px solid var(--border-color);
    }

    .prediction-sources {
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
        margin-top: 12px;
    }

    .prediction-source-tag {
        font-size: 0.7rem;
        padding: 4px 8px;
        background: rgba(0,0,0,0.05);
        border-radius: 12px;
        color: var(--text-secondary);
    }

    .prediction-disclaimer {
        font-size: 0.75rem;
        color: var(--text-secondary);
        margin-top: 16px;
        padding: 12px;
        background: rgba(255, 193, 7, 0.1);
        border-left: 3px solid #ffc107;
        border-radius: 4px;
    }

    /* Regional Breakdown Widget */
    .region-list {
        max-height: 300px;
        overflow-y: auto;
    }

    .region-item {
        display: flex;
        align-items: center;
        padding: 10px 0;
        border-bottom: 1px solid var(--border-color);
    }

    .region-item:last-child {
        border-bottom: none;
    }

    .region-name {
        flex: 1;
        font-size: 0.85rem;
        font-weight: 500;
    }

    .region-results {
        display: flex;
        gap: 12px;
        font-size: 0.8rem;
    }

    .region-winner-badge {
        font-size: 0.7rem;
        padding: 2px 6px;
        border-radius: 4px;
        color: white;
        font-weight: 600;
    }

    .region-winner-badge.npp { background: var(--npp-color); }
    .region-winner-badge.ndc { background: var(--ndc-color); }
    .region-population { font-size: 0.7rem; color: var(--text-secondary); font-weight: normal; }

    /* Historical Comparison Widget */
    .chart-container {
        height: 200px;
        position: relative;
    }

    .comparison-selector {
        display: flex;
        gap: 8px;
        margin-bottom: 16px;
    }

    .comparison-select {
        flex: 1;
        padding: 8px;
        border: 1px solid var(--border-color);
        border-radius: 8px;
        background: var(--bg-primary);
        color: var(--text-primary);
        font-size: 0.85rem;
    }

    /* Election AI Chat Widget */
    .election-chat {
        background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
        border-radius: 16px;
        padding: 20px;
        color: white;
    }

    .chat-input-container {
        display: flex;
        gap: 8px;
        margin-top: 12px;
    }

    .chat-input {
        flex: 1;
        padding: 12px 16px;
        border: none;
        border-radius: 24px;
        font-size: 0.9rem;
        background: rgba(255,255,255,0.1);
        color: white;
    }

    .chat-input::placeholder {
        color: rgba(255,255,255,0.5);
    }

    .chat-input:focus {
        outline: none;
        background: rgba(255,255,255,0.15);
    }

    .chat-send-btn {
        width: 44px;
        height: 44px;
        border-radius: 50%;
        border: none;
        background: var(--accent-color);
        color: white;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: transform 0.2s;
    }

    .chat-send-btn:hover {
        transform: scale(1.05);
    }

    .chat-response {
        margin-top: 16px;
        padding: 16px;
        background: rgba(255,255,255,0.1);
        border-radius: 12px;
        font-size: 0.9rem;
        line-height: 1.6;
        display: none;
    }

    .chat-response.active {
        display: block;
    }

    .chat-loading {
        display: flex;
        gap: 4px;
        padding: 8px 0;
    }

    .chat-loading-dot {
        width: 8px;
        height: 8px;
        background: rgba(255,255,255,0.5);
        border-radius: 50%;
        animation: chatPulse 1s infinite;
    }

    .chat-loading-dot:nth-child(2) { animation-delay: 0.2s; }
    .chat-loading-dot:nth-child(3) { animation-delay: 0.4s; }

    @keyframes chatPulse {
        0%, 100% { opacity: 0.5; transform: scale(1); }
        50% { opacity: 1; transform: scale(1.2); }
    }

    /* Dashboard sections */
    .dashboard-section {
        margin-bottom: 28px;
    }

    .dashboard-section-title {
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: var(--text-secondary);
        margin-bottom: 12px;
        padding-bottom: 6px;
        border-bottom: 1px solid var(--border-color);
    }

    /* Responsive Grid */
    @media (min-width: 768px) {
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 16px;
        }

        .widget-full {
            grid-column: 1 / -1;
        }

        .section-at-a-glance .dashboard-grid {
            grid-template-columns: 1fr 1fr;
        }
    }

    @media (min-width: 1024px) {
        .dashboard-grid {
            grid-template-columns: repeat(3, 1fr);
        }

        .section-at-a-glance .dashboard-grid {
            grid-template-columns: 1fr 1fr;
        }
    }

    /* Nav link for elections */
    .nav-elections-link {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 8px 16px;
        background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
        color: white;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        text-decoration: none;
        transition: transform 0.2s, box-shadow 0.2s;
    }

    .nav-elections-link:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        color: white;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="election-dashboard">
    <!-- Header -->
    <div class="election-header">
        <div class="election-header-content">
            <div class="election-title">
                <span class="election-title-icon">🗳️</span>
                Election Intelligence
            </div>
            <div class="election-subtitle">AI-powered analysis • Historical data • Live polls</div>
            
            <form method="get" action="<?php echo e(route('elections.dashboard')); ?>" id="electionSelectorForm" class="election-selector" style="display: flex; gap: 8px; margin-top: 16px; flex-wrap: wrap;">
                <select class="election-select" name="election_id" id="electionId" onchange="this.form.submit()" style="min-width: 220px;">
                    <?php $__currentLoopData = $electionList ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($opt->id); ?>" <?php echo e(($election && $election->id === $opt->id) ? 'selected' : ''); ?>>
                            <?php echo e($opt->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>
            <p class="election-subtitle" style="margin-top: 8px; font-size: 0.75rem;">Source: <a href="https://www.peacefmonline.com" target="_blank" rel="noopener">Peace FM Online</a></p>
        </div>
    </div>

    <!-- Dashboard Content -->
    <div class="dashboard-content">

        <?php if($election && ($raceOverview['type'] ?? '') === 'no_data' && empty($scraped['national'] ?? null)): ?>
        <div class="widget widget-full mb-3">
            <div class="alert alert-info mb-0">
                <strong>No Peace FM data for this election yet.</strong>
                Run: <code>node scripts/scrape-peacefm.mjs <?php echo e($election->year); ?><?php echo e($election->type === 'presidential_runoff' ? 'a' : ''); ?></code> then <code>php artisan election:import-peacefm <?php echo e($election->year); ?><?php echo e($election->type === 'presidential_runoff' ? 'a' : ''); ?></code>
            </div>
        </div>
        <?php endif; ?>

        <!-- Section: At a glance -->
        <div class="dashboard-section section-at-a-glance">
            <h2 class="dashboard-section-title">At a glance</h2>
            <div class="dashboard-grid">

            <!-- Race Overview Widget (primary – always populated from DB or scraped fallback) -->
            <div class="widget widget-full race-overview-widget">
                <div class="widget-header">
                    <div class="widget-title">
                        <span class="widget-icon">🏆</span>
                        Race Overview
                        <?php if($election): ?>
                            – <?php echo e($election->name); ?>

                        <?php endif; ?>
                    </div>
                    <?php if(($raceOverview['type'] ?? '') === 'actual'): ?>
                        <span class="badge bg-success">Final Results</span>
                    <?php elseif(($raceOverview['type'] ?? '') === 'poll'): ?>
                        <span class="badge bg-warning text-dark">Based on Polls</span>
                    <?php elseif(($raceOverview['type'] ?? '') === 'no_data'): ?>
                        <span class="badge bg-secondary">No results yet</span>
                    <?php endif; ?>
                </div>
                <?php if($scraped && ($raceOverview['type'] ?? '') === 'actual'): ?>
                <p class="small text-muted mb-2">Source: <a href="https://www.peacefmonline.com" target="_blank" rel="noopener">Peace FM Online</a></p>
                <?php endif; ?>

                <?php if(($raceOverview['type'] ?? '') === 'no_data'): ?>
                <div class="race-overview-no-data py-4 text-center">
                    <p class="text-muted mb-0">No results data for this election yet. Run scrapers and import, or add polls.</p>
                    <?php if($election): ?>
                    <p class="small text-muted mt-2 mb-0">Select another year or type above, or use Poll Tracker / AI Prediction below.</p>
                    <?php endif; ?>
                </div>
                <?php else: ?>
                <div class="race-overview">
                    <div class="party-card">
                        <div class="party-percentage npp"><?php echo e(number_format($raceOverview['npp'] ?? 0, 2)); ?>%</div>
                        <div class="party-name">NPP</div>
                        <div class="party-bar">
                            <div class="party-bar-fill npp" style="width: <?php echo e(min(100, $raceOverview['npp'] ?? 0)); ?>%"></div>
                        </div>
                        <?php if(isset($raceOverview['npp_votes']) && ($raceOverview['npp_votes'] ?? 0) > 0): ?>
                            <div class="poll-meta mt-1"><?php echo e(number_format($raceOverview['npp_votes'])); ?> votes</div>
                        <?php endif; ?>
                    </div>
                    <div class="party-card">
                        <div class="party-percentage ndc"><?php echo e(number_format($raceOverview['ndc'] ?? 0, 2)); ?>%</div>
                        <div class="party-name">NDC</div>
                        <div class="party-bar">
                            <div class="party-bar-fill ndc" style="width: <?php echo e(min(100, $raceOverview['ndc'] ?? 0)); ?>%"></div>
                        </div>
                        <?php if(isset($raceOverview['ndc_votes']) && ($raceOverview['ndc_votes'] ?? 0) > 0): ?>
                            <div class="poll-meta mt-1"><?php echo e(number_format($raceOverview['ndc_votes'])); ?> votes</div>
                        <?php endif; ?>
                    </div>
                    <?php if(($raceOverview['others'] ?? 0) > 0): ?>
                    <div class="party-card">
                        <div class="party-percentage others"><?php echo e(number_format($raceOverview['others'], 2)); ?>%</div>
                        <div class="party-name">Others</div>
                        <div class="party-bar">
                            <div class="party-bar-fill others" style="width: <?php echo e($raceOverview['others']); ?>%"></div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="race-status">
                    <div class="race-status-label">
                        <?php if(($raceOverview['type'] ?? '') === 'actual'): ?>
                            Winner
                        <?php else: ?>
                            Leading (per <?php echo e($raceOverview['poll_source'] ?? 'Latest Poll'); ?>)
                        <?php endif; ?>
                    </div>
                    <div class="race-status-value">
                        <?php echo e($raceOverview['winner'] ?? ($raceOverview['npp'] > $raceOverview['ndc'] ? 'NPP' : 'NDC')); ?>

                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Regional Breakdown Widget -->
            <div class="widget">
                <div class="widget-header">
                    <div class="widget-title">
                        <span class="widget-icon">🗺️</span>
                        Regional Breakdown
                    </div>
                    <select class="form-select form-select-sm" style="width: auto; font-size: 0.75rem;">
                        <option>All Regions</option>
                    </select>
                </div>

                <div class="region-list">
                    <?php $__empty_1 = true; $__currentLoopData = $regionalBreakdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="region-item">
                        <div class="region-name">
                            <?php echo e($region['region']); ?>

                            <?php if(!empty($region['population'])): ?>
                            <span class="region-population" title="<?php echo e($censusYear ?? 2021); ?> Census">(<?php echo e(number_format($region['population'] / 1000, 0)); ?>K)</span>
                            <?php endif; ?>
                        </div>
                        <div class="region-results">
                            <span class="npp"><?php echo e(number_format($region['npp_pct'], 0)); ?>%</span>
                            <span class="ndc"><?php echo e(number_format($region['ndc_pct'], 0)); ?>%</span>
                            <?php if($region['winner'] !== '-'): ?>
                            <span class="region-winner-badge <?php echo e(strtolower($region['winner'])); ?>">
                                <?php echo e($region['winner']); ?>

                            </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted text-center py-3">No regional data available</p>
                    <?php endif; ?>
                </div>

                <a href="<?php echo e(route('elections.compare')); ?>" class="btn btn-outline-secondary btn-sm w-100 mt-3">
                    Compare Regions Across Years →
                </a>
            </div>

            </div>
        </div>

        <!-- Section: Polls & predictions -->
        <div class="dashboard-section">
            <h2 class="dashboard-section-title">Polls & predictions</h2>
            <div class="dashboard-grid">

            <!-- Poll Tracker Widget -->
            <div class="widget">
                <div class="widget-header">
                    <div class="widget-title">
                        <span class="widget-icon">📊</span>
                        Poll Tracker
                    </div>
                    <a href="<?php echo e(route('elections.polls')); ?>" class="widget-action">See all →</a>
                </div>
                
                <?php $__empty_1 = true; $__currentLoopData = $recentPolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $poll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="poll-item">
                    <div class="poll-header">
                        <div class="poll-source"><?php echo e($poll->pollster_name); ?></div>
                        <div class="poll-date"><?php echo e($poll->date_conducted->format('M j')); ?></div>
                    </div>
                    <div class="poll-results">
                        <?php $__currentLoopData = $poll->results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="poll-result">
                                <span class="party <?php echo e(strtolower($result->party->short_name ?? '')); ?>"><?php echo e($result->party->short_name ?? 'Other'); ?></span>
                                <?php echo e(number_format($result->percentage, 0)); ?>%
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="poll-meta">
                        <?php if($poll->sample_size): ?>
                            n=<?php echo e(number_format($poll->sample_size)); ?>

                        <?php endif; ?>
                        <?php if($poll->margin_of_error): ?>
                            • ±<?php echo e($poll->margin_of_error); ?>%
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center text-muted py-4">
                    <p>No polls available yet</p>
                </div>
                <?php endif; ?>

                <a href="<?php echo e(route('elections.polls')); ?>?add=1" class="add-poll-btn">
                    <span>+</span> Add Poll
                </a>
            </div>

            <!-- Social Sentiment Widget -->
            <div class="widget">
                <div class="widget-header">
                    <div class="widget-title">
                        <span class="widget-icon">🗣️</span>
                        Social Sentiment
                    </div>
                    <span class="badge bg-secondary">X/Twitter</span>
                </div>
                
                <?php if($socialSentiment['available'] ?? false): ?>
                    <?php $__currentLoopData = $socialSentiment['party_sentiment']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $party => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="sentiment-party">
                        <span class="sentiment-party-name <?php echo e(strtolower($party)); ?>"><?php echo e($party); ?></span>
                        <div class="sentiment-bar-container">
                            <div class="sentiment-positive" style="width: <?php echo e(($data['positive'] / max($data['total'], 1)) * 100); ?>%"></div>
                            <div class="sentiment-neutral" style="width: <?php echo e(($data['neutral'] / max($data['total'], 1)) * 100); ?>%"></div>
                            <div class="sentiment-negative" style="width: <?php echo e(($data['negative'] / max($data['total'], 1)) * 100); ?>%"></div>
                        </div>
                        <span class="sentiment-pct"><?php echo e($data['positive_pct']); ?>%</span>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="poll-meta mt-3">
                        <?php echo e(number_format($socialSentiment['total_mentions'])); ?> mentions analyzed
                    </div>
                <?php else: ?>
                <div class="sentiment-unavailable">
                    <div class="sentiment-unavailable-icon">📡</div>
                    <p><?php echo e($socialSentiment['message'] ?? 'Social sentiment tracking coming soon'); ?></p>
                    <small>Connect X/Twitter API to enable</small>
                </div>
                <?php endif; ?>
            </div>

            <!-- AI Prediction Widget -->
            <div class="widget widget-full">
                <div class="widget-header">
                    <div class="widget-title">
                        <span class="widget-icon">🤖</span>
                        AI Prediction
                    </div>
                    <?php if($election && $election->status !== 'completed'): ?>
                    <button class="btn btn-sm btn-outline-primary" onclick="generatePrediction()">
                        Refresh Analysis
                    </button>
                    <?php endif; ?>
                </div>
                
                <?php if($predictions->isNotEmpty()): ?>
                    <div class="row">
                        <?php $__currentLoopData = $predictions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prediction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 mb-3">
                            <div class="prediction-card">
                                <div class="prediction-header">
                                    <span class="prediction-party <?php echo e(strtolower($prediction->party->short_name ?? '')); ?>">
                                        <?php echo e($prediction->party->short_name ?? 'Unknown'); ?>

                                    </span>
                                    <span class="prediction-probability">
                                        <?php echo e(number_format($prediction->win_probability, 1)); ?>%
                                    </span>
                                </div>
                                <div class="poll-meta">
                                    Win probability based on historical data, polls, and news analysis
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <?php if($predictions->first()?->qualitative_analysis): ?>
                    <div class="prediction-analysis">
                        <?php echo e($predictions->first()->qualitative_analysis); ?>

                    </div>
                    <?php endif; ?>
                    
                    <div class="prediction-sources">
                        <span class="prediction-source-tag">📚 Historical Data</span>
                        <span class="prediction-source-tag">📊 Poll Averages</span>
                        <span class="prediction-source-tag">📰 News Analysis</span>
                        <?php if($socialSentiment['available'] ?? false): ?>
                        <span class="prediction-source-tag">💬 Social Sentiment</span>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                <div class="text-center py-4">
                    <p class="text-muted">No predictions generated yet</p>
                    <?php if($election && $election->status !== 'completed'): ?>
                    <button class="btn btn-primary" onclick="generatePrediction()">
                        Generate AI Prediction
                    </button>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <div class="prediction-disclaimer">
                    ⚠️ <strong>Disclaimer:</strong> AI predictions are based on available data and statistical modeling. 
                    They are not guarantees of outcomes. Actual election results may vary significantly. 
                    Always verify information from official sources.
                </div>
            </div>

            </div>
        </div>

        <!-- Section: Context -->
        <div class="dashboard-section">
            <h2 class="dashboard-section-title">Context</h2>
            <div class="dashboard-grid">

            <?php
                $hasScraped = !empty($scraped) && ($scraped['national'] ?? $scraped['swing'] ?? $scraped['regional_analysis'] ?? null);
            ?>
            <?php if($hasScraped): ?>
            <!-- Peace FM: swing, marginal, regional comparison -->
            <div class="widget widget-full external-sources-widget">
                <div class="widget-header">
                    <div class="widget-title">
                        <span class="widget-icon">📡</span>
                        Peace FM – <?php echo e($election->name ?? 'Selected election'); ?>

                    </div>
                    <span class="badge bg-secondary">Peace FM Online</span>
                </div>
                <p class="text-muted small mb-3">Data from <a href="https://www.peacefmonline.com" target="_blank" rel="noopener">Peace FM Online</a>. Race Overview & Regional Breakdown above use this source.</p>

                <div class="external-section mb-4">
                    <?php $regAnalysis = $scraped['regional_analysis']['regional_comparison'] ?? []; ?>
                    <?php if(count($regAnalysis) > 0): ?>
                    <div class="mb-3">
                        <strong class="d-block mb-1">Regional comparison</strong>
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered" style="font-size: 0.75rem;">
                                <thead><tr><th>Region</th><th>NDC <?php echo e($comparisonPrevYear ?? 'prev'); ?></th><th>NDC <?php echo e($comparisonCurrYear ?? 'this'); ?></th><th>G/L</th><th>NPP <?php echo e($comparisonPrevYear ?? 'prev'); ?></th><th>NPP <?php echo e($comparisonCurrYear ?? 'this'); ?></th><th>G/L</th></tr></thead>
                                <tbody>
                                <?php $__currentLoopData = $regAnalysis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($r['region'] ?? ''); ?></td>
                                    <td><?php echo e($r['ndc_1'] ?? $r['ndc_2016'] ?? ''); ?>%</td>
                                    <td><?php echo e($r['ndc_2'] ?? $r['ndc_2020'] ?? ''); ?>%</td>
                                    <td><?php echo e(isset($r['ndc_gl']) ? ($r['ndc_gl'] >= 0 ? '+' : '') . $r['ndc_gl'] . '%' : ''); ?></td>
                                    <td><?php echo e($r['npp_1'] ?? $r['npp_2016'] ?? ''); ?>%</td>
                                    <td><?php echo e($r['npp_2'] ?? $r['npp_2020'] ?? ''); ?>%</td>
                                    <td><?php echo e(isset($r['npp_gl']) ? ($r['npp_gl'] >= 0 ? '+' : '') . $r['npp_gl'] . '%' : ''); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php $swing = $scraped['swing']['swing_list'] ?? []; $swingByRegion = $scraped['swing']['by_region'] ?? []; $marginal = $scraped['marginal']['marginal_list'] ?? []; ?>
                    <?php if(count($swingByRegion) > 0): ?>
                    <div class="mb-3"><strong class="d-block mb-1">Swing by region</strong>
                        <div class="table-responsive"><table class="table table-sm table-bordered" style="font-size: 0.75rem;">
                            <thead><tr><th>Region</th><th>Total</th><th>Constituencies</th></tr></thead>
                            <tbody><?php $__currentLoopData = array_slice($swingByRegion, 0, 16); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><tr><td><?php echo e($s['region'] ?? ''); ?></td><td><?php echo e($s['total'] ?? ''); ?></td><td><?php echo e($s['constituencies'] ?? ''); ?></td></tr><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></tbody></table></div>
                    </div>
                    <?php endif; ?>
                    <?php if(count($swing) > 0 && count($swingByRegion) == 0): ?>
                    <div class="mb-3"><strong class="d-block mb-1">Swing constituencies (sample)</strong>
                        <div class="table-responsive"><table class="table table-sm table-bordered" style="font-size: 0.75rem;">
                            <thead><tr><th>#</th><th>Constituency</th><th>Region</th></tr></thead>
                            <tbody><?php $__currentLoopData = array_slice($swing, 0, 10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><tr><td><?php echo e($s['no'] ?? ''); ?></td><td><?php echo e($s['constituency'] ?? ''); ?></td><td><?php echo e($s['region'] ?? ''); ?></td></tr><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></tbody></table></div>
                    </div>
                    <?php endif; ?>
                    <?php if(count($marginal) > 0): ?>
                    <div class="mb-2"><strong class="d-block mb-1">Marginal wins (sample)</strong>
                        <div class="table-responsive"><table class="table table-sm table-bordered" style="font-size: 0.75rem;">
                            <thead><tr><th>Constituency</th><th>Vote diff</th></tr></thead>
                            <tbody><?php $__currentLoopData = array_slice($marginal, 0, 8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><tr><td><?php echo e($m['constituency'] ?? ''); ?></td><td><?php echo e($m['vote_difference'] ?? ''); ?></td></tr><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></tbody></table></div>
                    </div>
                    <?php endif; ?>
                    <p class="small mb-0"><a href="https://www.peacefmonline.com" target="_blank" rel="noopener">Peace FM Online →</a></p>
                </div>
            </div>
            <?php endif; ?>

            <!-- Population Census Widget -->
            <div class="widget">
                <div class="widget-header">
                    <div class="widget-title">
                        <span class="widget-icon">👥</span>
                        Population (<?php echo e($censusYear); ?> Census)
                    </div>
                </div>
                <?php if($totalPopulation > 0): ?>
                <div class="census-total mb-3" style="font-size: 1.5rem; font-weight: 700; color: var(--accent-color);">
                    <?php echo e(number_format($totalPopulation)); ?>

                </div>
                <div class="census-regions" style="max-height: 200px; overflow-y: auto;">
                    <?php $__currentLoopData = $censusData->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex justify-content-between py-1" style="font-size: 0.8rem;">
                        <span><?php echo e($r->name); ?></span>
                        <span><?php echo e(number_format($r->population)); ?></span>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <p class="poll-meta mt-2 mb-0">
                    <small>Source: <?php echo e($censusSource); ?></small>
                </p>
                <?php else: ?>
                <p class="text-muted">Census data loading...</p>
                <?php endif; ?>
            </div>

            <!-- Historical Trend Widget -->
            <div class="widget">
                <div class="widget-header">
                    <div class="widget-title">
                        <span class="widget-icon">📈</span>
                        Historical Trend
                    </div>
                </div>
                
                <div class="chart-container">
                    <canvas id="historicalChart"></canvas>
                </div>
                
                <div class="mt-3">
                    <?php $__currentLoopData = $historicalData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex justify-content-between align-items-center py-1" style="font-size: 0.8rem;">
                        <span><?php echo e($data['year']); ?></span>
                        <div>
                            <span class="npp"><?php echo e($data['npp_pct']); ?>%</span> /
                            <span class="ndc"><?php echo e($data['ndc_pct']); ?>%</span>
                            <span class="badge <?php echo e($data['winner'] === 'NPP' ? 'bg-primary' : 'bg-success'); ?>" style="font-size: 0.65rem;">
                                <?php echo e($data['winner']); ?>

                            </span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Historical Chart
    const historicalData = <?php echo json_encode($historicalData, 15, 512) ?>;
    
    if (historicalData.length > 0) {
        const ctx = document.getElementById('historicalChart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: historicalData.map(d => d.year),
                datasets: [
                    {
                        label: 'NPP',
                        data: historicalData.map(d => d.npp_pct),
                        borderColor: '#0057B7',
                        backgroundColor: 'rgba(0, 87, 183, 0.1)',
                        fill: true,
                        tension: 0.3,
                    },
                    {
                        label: 'NDC',
                        data: historicalData.map(d => d.ndc_pct),
                        borderColor: '#009739',
                        backgroundColor: 'rgba(0, 151, 57, 0.1)',
                        fill: true,
                        tension: 0.3,
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: { boxWidth: 12, padding: 8 }
                    }
                },
                scales: {
                    y: {
                        min: 0,
                        max: 100,
                        ticks: { callback: value => value + '%' }
                    }
                }
            }
        });
    }

    // Dashboard functions (form submit handles year/type via GET)
    function updateDashboard() {
        var form = document.getElementById('electionSelectorForm');
        if (form) form.submit();
    }

    function generatePrediction() {
        <?php if($election): ?>
        const btn = event.target;
        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm"></span> Generating...';
        
        fetch('<?php echo e(route("elections.predict")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ election_id: <?php echo e($election->id); ?> })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                window.location.reload();
            } else {
                alert('Failed to generate prediction: ' + (data.error || 'Unknown error'));
                btn.disabled = false;
                btn.innerHTML = 'Refresh Analysis';
            }
        })
        .catch(error => {
            alert('Error generating prediction');
            btn.disabled = false;
            btn.innerHTML = 'Refresh Analysis';
        });
        <?php endif; ?>
    }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/mews/resources/views/elections/dashboard.blade.php ENDPATH**/ ?>