@extends('layouts.user-dashboard')

@section('title', 'Reading History')

@section('content')
<div class="mobile-page">
    <!-- Page Header -->
    <div class="page-header">
        <div class="header-content">
            <a href="{{ route('user.dashboard') }}" class="back-button">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div class="header-text">
                <h1 class="page-title">Reading History</h1>
                <p class="page-subtitle">Articles you've read</p>
            </div>
        </div>
    </div>

    <!-- Reading History Content -->
    <div class="page-content">
        @if($history->count() > 0)
            <div class="history-list">
                @foreach($history as $item)
                    <a href="{{ route('news.deep-dive.show', ['article_id' => $item->article_id]) }}" class="history-item clickable">
                        <div class="history-icon">
                            <i class="fas fa-newspaper"></i>
                        </div>
                        <div class="history-details">
                            <div class="history-title">{{ $item->article_title }}</div>
                            <div class="history-meta">
                                <span class="history-category">{{ $item->article_subcategory ?? $item->article_category }}</span>
                                <span class="history-time">{{ $item->read_at->diffForHumans() }}</span>
                            </div>
                            @if($item->reading_time_seconds)
                                <div class="history-stats">
                                    <span class="reading-time">
                                        <i class="fas fa-clock"></i>
                                        {{ $item->reading_time_formatted }}
                                    </span>
                                    @if($item->scroll_percentage)
                                        <span class="scroll-percentage">
                                            <i class="fas fa-chart-line"></i>
                                            {{ round($item->scroll_percentage * 100) }}% read
                                        </span>
                                    @endif
                                </div>
                            @endif
                        </div>
                        <div class="history-actions">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </a>
                @endforeach
            </div>

            <!-- Pagination -->
            @if($history->hasPages())
                <div class="pagination-wrapper">
                    {{ $history->links() }}
                </div>
            @endif
        @else
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="fas fa-newspaper"></i>
                </div>
                <h3>No Reading History</h3>
                <p>You haven't read any articles yet. Start exploring to build your reading history!</p>
                <a href="{{ route('home') }}" class="btn btn-primary">
                    <i class="fas fa-home"></i>
                    Start Reading
                </a>
            </div>
        @endif
    </div>
</div>

<style>
/* Mobile Page Styles */
.mobile-page {
    padding: 1rem;
    max-width: 100%;
    margin: 0 auto;
}

/* Page Header */
.page-header {
    margin-bottom: 2rem;
}

.header-content {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.back-button {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    background: var(--bg-secondary);
    border: 1px solid var(--border-color);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text-primary);
    text-decoration: none;
    transition: all 0.3s ease;
}

.back-button:hover {
    background: var(--accent-gradient);
    color: white;
    text-decoration: none;
}

.header-text {
    flex: 1;
}

.page-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    background: var(--accent-gradient);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.page-subtitle {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin: 0.25rem 0 0 0;
}

/* Page Content */
.page-content {
    margin-bottom: 2rem;
}

/* History List */
.history-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.history-item {
    background: var(--bg-secondary);
    border-radius: 12px;
    border: 1px solid var(--border-color);
    box-shadow: var(--card-shadow);
    padding: 1.25rem;
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    transition: all 0.3s ease;
}

.history-item:hover {
    transform: translateY(-2px);
    box-shadow: var(--card-shadow-hover);
}

/* Clickable Elements */
.clickable {
    text-decoration: none;
    color: inherit;
    display: block;
    transition: all 0.3s ease;
}

.clickable:hover {
    text-decoration: none;
    color: inherit;
}

.history-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: var(--accent-gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.history-details {
    flex: 1;
    min-width: 0;
}

.history-title {
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-primary);
    line-height: 1.3;
    margin-bottom: 0.5rem;
}

.history-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
    align-items: center;
    margin-bottom: 0.5rem;
}

.history-category {
    font-size: 0.8rem;
    color: var(--accent-color);
    background: rgba(255, 107, 53, 0.1);
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
    font-weight: 500;
}


.history-time {
    font-size: 0.8rem;
    color: var(--text-secondary);
}

.history-stats {
    display: flex;
    gap: 1rem;
    align-items: center;
}

.reading-time,
.scroll-percentage {
    font-size: 0.8rem;
    color: var(--text-secondary);
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.history-actions {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    flex-shrink: 0;
}

.history-actions i.fa-chevron-right {
    color: var(--text-secondary);
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.history-item.clickable:hover .history-actions i.fa-chevron-right {
    color: var(--accent-color);
    transform: translateX(2px);
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 3rem 1.5rem;
    color: var(--text-secondary);
}

.empty-icon {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: var(--accent-gradient);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 2rem;
    margin: 0 auto 1.5rem;
}

.empty-state h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 0.5rem;
}

.empty-state p {
    font-size: 1rem;
    margin-bottom: 1.5rem;
    line-height: 1.5;
}

/* Pagination */
.pagination-wrapper {
    margin-top: 2rem;
    display: flex;
    justify-content: center;
}

.pagination {
    display: flex;
    gap: 0.5rem;
    align-items: center;
}

.pagination .page-link {
    background: var(--bg-secondary);
    border: 1px solid var(--border-color);
    color: var(--text-primary);
    padding: 0.5rem 0.75rem;
    border-radius: 8px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.pagination .page-link:hover {
    background: var(--accent-gradient);
    color: white;
    text-decoration: none;
}

.pagination .page-item.active .page-link {
    background: var(--accent-gradient);
    color: white;
    border-color: var(--accent-color);
}

/* Responsive Design */
@media (max-width: 480px) {
    .mobile-page {
        padding: 0.75rem;
    }
    
    .history-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .history-actions {
        align-self: flex-end;
    }
    
    .history-meta {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.25rem;
    }
    
    .history-stats {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
}

@media (min-width: 768px) {
    .mobile-page {
        max-width: 600px;
        margin: 0 auto;
    }
}
</style>
@endsection

