@extends('layouts.user-dashboard')

@section('title', 'Preferences')

@section('content')
<div class="mobile-page">
    <!-- Page Header -->
    <div class="page-header">
        <div class="header-content">
            <a href="{{ route('user.dashboard') }}" class="back-button">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div class="header-text">
                <h1 class="page-title">Preferences</h1>
                <p class="page-subtitle">Customize your experience</p>
            </div>
        </div>
    </div>

    <!-- Preferences Content -->
    <div class="page-content">
        @if(session('success'))
            <div class="alert alert-success" style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 8px; margin-bottom: 1rem; border: 1px solid #c3e6cb;">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif
        
        @if($errors->any())
            <div class="alert alert-danger" style="background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 8px; margin-bottom: 1rem; border: 1px solid #f5c6cb;">
                <i class="fas fa-exclamation-triangle"></i> Please fix the following errors:
                <ul style="margin: 0.5rem 0 0 1rem;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        <form method="POST" action="{{ route('user.preferences.update') }}" class="preferences-form">
            @csrf
            
            <!-- Theme Settings -->
            <div class="preference-section">
                <h3 class="section-title">
                    <i class="fas fa-palette"></i>
                    Appearance
                </h3>
                
                <div class="preference-group">
                    <label class="preference-label">Theme</label>
                    <div class="theme-options">
                        <label class="theme-option">
                            <input type="radio" name="theme" value="dark" {{ ($user->preferences->theme ?? 'dark') == 'dark' ? 'checked' : '' }}>
                            <div class="theme-preview dark">
                                <div class="theme-header"></div>
                                <div class="theme-content"></div>
                            </div>
                            <span class="theme-name">Dark</span>
                        </label>
                        
                        <label class="theme-option">
                            <input type="radio" name="theme" value="light" {{ ($user->preferences->theme ?? 'dark') == 'light' ? 'checked' : '' }}>
                            <div class="theme-preview light">
                                <div class="theme-header"></div>
                                <div class="theme-content"></div>
                            </div>
                            <span class="theme-name">Light</span>
                        </label>
                        
                        <label class="theme-option">
                            <input type="radio" name="theme" value="auto" {{ ($user->preferences->theme ?? 'dark') == 'auto' ? 'checked' : '' }}>
                            <div class="theme-preview auto">
                                <div class="theme-header"></div>
                                <div class="theme-content"></div>
                            </div>
                            <span class="theme-name">Auto</span>
                        </label>
                    </div>
                </div>
                
                <div class="preference-group">
                    <label class="preference-label">Font Size</label>
                    <div class="font-size-options">
                        <label class="font-option">
                            <input type="radio" name="font_size" value="small" {{ ($user->preferences->font_size ?? 'medium') == 'small' ? 'checked' : '' }}>
                            <span class="font-preview small">Aa</span>
                            <span class="font-name">Small</span>
                        </label>
                        
                        <label class="font-option">
                            <input type="radio" name="font_size" value="medium" {{ ($user->preferences->font_size ?? 'medium') == 'medium' ? 'checked' : '' }}>
                            <span class="font-preview medium">Aa</span>
                            <span class="font-name">Medium</span>
                        </label>
                        
                        <label class="font-option">
                            <input type="radio" name="font_size" value="large" {{ ($user->preferences->font_size ?? 'medium') == 'large' ? 'checked' : '' }}>
                            <span class="font-preview large">Aa</span>
                            <span class="font-name">Large</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- News Interests -->
<!--
            <div class="preference-section">
                <h3 class="section-title">
                    <i class="fas fa-newspaper"></i>
                    News Interests
                </h3>
                
                 <div class="preference-group">
                    <label class="preference-label">Select your preferred news categories</label>
                    <div class="interests-grid">
                        @php
                            // Use the actual subcategories from crawler database as news interest options
                            $availableNewsInterests = [
                                'Politics', 'Business', 'Entertainment', 'Sports', 
                                'International', 'General', 'Local', 'Technology'
                            ];
                            $userInterests = $user->profile->interests ?? [];
                        @endphp
                        
                        @foreach($availableNewsInterests as $interest)
                            <label class="interest-option">
                                <input type="checkbox" 
                                       name="interests[]" 
                                       value="{{ $interest }}"
                                       {{ in_array($interest, $userInterests) ? 'checked' : '' }}>
                                <span class="interest-label">{{ $interest }}</span>
                            </label>
                        @endforeach
                    </div>
                    <div class="form-text">These categories will appear as quick access buttons in the chatbot</div>
                </div>
            </div> -->

            <!-- Reading Preferences -->
            <div class="preference-section">
                <h3 class="section-title">
                    <i class="fas fa-book-open"></i>
                    Reading
                </h3>
                
                <div class="preference-group">
                    <label class="preference-label">News Display Mode</label>
                    <select name="news_display_mode" class="preference-select">
                        <option value="cards" {{ ($user->preferences->news_display_mode ?? 'cards') == 'cards' ? 'selected' : '' }}>Cards</option>
                        <option value="list" {{ ($user->preferences->news_display_mode ?? 'cards') == 'list' ? 'selected' : '' }}>List</option>
                        <option value="compact" {{ ($user->preferences->news_display_mode ?? 'cards') == 'compact' ? 'selected' : '' }}>Compact</option>
                    </select>
                </div>
                
                <div class="preference-group">
                    <label class="preference-label">Articles Per Page</label>
                    <select name="articles_per_page" class="preference-select">
                        <option value="10" {{ ($user->preferences->articles_per_page ?? 20) == 10 ? 'selected' : '' }}>10</option>
                        <option value="20" {{ ($user->preferences->articles_per_page ?? 20) == 20 ? 'selected' : '' }}>20</option>
                        <option value="30" {{ ($user->preferences->articles_per_page ?? 20) == 30 ? 'selected' : '' }}>30</option>
                        <option value="50" {{ ($user->preferences->articles_per_page ?? 20) == 50 ? 'selected' : '' }}>50</option>
                    </select>
                </div>
                
                <div class="preference-group">
                    <label class="preference-switch">
                        <input type="checkbox" name="auto_play_videos" {{ ($user->preferences->auto_play_videos ?? false) ? 'checked' : '' }}>
                        <span class="switch-slider"></span>
                        <span class="switch-label">Auto-play videos</span>
                    </label>
                </div>
                
                <div class="preference-group">
                    <label class="preference-switch">
                        <input type="checkbox" name="show_images" {{ ($user->preferences->show_images ?? true) ? 'checked' : '' }}>
                        <span class="switch-slider"></span>
                        <span class="switch-label">Show images in articles</span>
                    </label>
                </div>
            </div>

            <!-- AI Features -->
            <div class="preference-section">
                <h3 class="section-title">
                    <i class="fas fa-robot"></i>
                    AI Features
                </h3>
                
                <div class="preference-group">
                    <label class="preference-switch">
                        <input type="checkbox" name="ai_suggestions" {{ ($user->preferences->ai_suggestions ?? true) ? 'checked' : '' }}>
                        <span class="switch-slider"></span>
                        <span class="switch-label">Enable AI suggestions</span>
                    </label>
                </div>
                
                <div class="preference-group">
                    <label class="preference-switch">
                        <input type="checkbox" name="trending_alerts" {{ ($user->preferences->trending_alerts ?? true) ? 'checked' : '' }}>
                        <span class="switch-slider"></span>
                        <span class="switch-label">Trending news alerts</span>
                    </label>
                </div>
            </div>

            <!-- Privacy & Data -->
            <div class="preference-section">
                <h3 class="section-title">
                    <i class="fas fa-shield-alt"></i>
                    Privacy & Data
                </h3>
                
                <div class="preference-group">
                    <label class="preference-label">Timezone</label>
                    <select name="timezone" class="preference-select">
                        <option value="Africa/Accra" {{ ($user->preferences->timezone ?? 'Africa/Accra') == 'Africa/Accra' ? 'selected' : '' }}>Africa/Accra (GMT+0)</option>
                        <option value="UTC" {{ ($user->preferences->timezone ?? 'Africa/Accra') == 'UTC' ? 'selected' : '' }}>UTC (GMT+0)</option>
                        <option value="America/New_York" {{ ($user->preferences->timezone ?? 'Africa/Accra') == 'America/New_York' ? 'selected' : '' }}>America/New_York (GMT-5)</option>
                        <option value="Europe/London" {{ ($user->preferences->timezone ?? 'Africa/Accra') == 'Europe/London' ? 'selected' : '' }}>Europe/London (GMT+0)</option>
                    </select>
                </div>
            </div>

            <!-- Notification Settings -->
            <div class="preference-section">
                <h3 class="section-title">
                    <i class="fas fa-bell"></i>
                    Notifications
                </h3>
                
                <div class="preference-group">
                    <label class="preference-label">Notification Types</label>
                    <div class="notification-options">
                        <label class="notification-option">
                            <input type="checkbox" name="breaking_news_enabled" value="1" {{ ($user->notificationSubscription->breaking_news_enabled ?? true) ? 'checked' : '' }}>
                            <div class="notification-icon breaking">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <div class="notification-details">
                                <span class="notification-name">Breaking News</span>
                                <span class="notification-desc">Get instant alerts for breaking news</span>
                            </div>
                        </label>
                        
                        <label class="notification-option">
                            <input type="checkbox" name="daily_digest_enabled" value="1" {{ ($user->notificationSubscription->daily_digest_enabled ?? true) ? 'checked' : '' }}>
                            <div class="notification-icon daily">
                                <i class="fas fa-newspaper"></i>
                            </div>
                            <div class="notification-details">
                                <span class="notification-name">Daily Digest</span>
                                <span class="notification-desc">Daily summary of top stories</span>
                            </div>
                        </label>
                        
                        <label class="notification-option">
                            <input type="checkbox" name="weekly_summary_enabled" value="1" {{ ($user->notificationSubscription->weekly_summary_enabled ?? true) ? 'checked' : '' }}>
                            <div class="notification-icon weekly">
                                <i class="fas fa-calendar-week"></i>
                            </div>
                            <div class="notification-details">
                                <span class="notification-name">Weekly Summary</span>
                                <span class="notification-desc">Weekly roundup of important news</span>
                            </div>
                        </label>
                        
                        <label class="notification-option">
                            <input type="checkbox" name="marketing_enabled" value="1" {{ ($user->notificationSubscription->marketing_enabled ?? false) ? 'checked' : '' }}>
                            <div class="notification-icon marketing">
                                <i class="fas fa-bullhorn"></i>
                            </div>
                            <div class="notification-details">
                                <span class="notification-name">Marketing</span>
                                <span class="notification-desc">Promotional content and updates</span>
                            </div>
                        </label>
                    </div>
                </div>
                
                
                <div class="preference-group">
                    <label class="preference-label">Quiet Hours</label>
                    <div class="quiet-hours">
                        <div class="time-input-group">
                            <label for="quiet_hours_start">From:</label>
                            <input type="time" id="quiet_hours_start" name="quiet_hours_start" value="{{ $user->notificationSubscription->quiet_hours_start ?? '' }}">
                        </div>
                        <div class="time-input-group">
                            <label for="quiet_hours_end">To:</label>
                            <input type="time" id="quiet_hours_end" name="quiet_hours_end" value="{{ $user->notificationSubscription->quiet_hours_end ?? '' }}">
                        </div>
                    </div>
                    <div class="form-text">Set quiet hours when you don't want to receive notifications</div>
                </div>
            </div>

            <!-- Save Button -->
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i>
                    Save Preferences
                </button>
            </div>
        </form>
    </div>
</div>

<style>
/* Mobile Page Styles */
.mobile-page {
    padding: 1rem;
    max-width: 100%;
    margin: 0 auto;
}

/* Page Header */
.page-header {
    margin-bottom: 2rem;
}

.header-content {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.back-button {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    background: var(--bg-secondary);
    border: 1px solid var(--border-color);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text-primary);
    text-decoration: none;
    transition: all 0.3s ease;
}

.back-button:hover {
    background: var(--accent-gradient);
    color: white;
    text-decoration: none;
}

.header-text {
    flex: 1;
}

.page-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0;
    background: var(--accent-gradient);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.page-subtitle {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin: 0.25rem 0 0 0;
}

.notification-options {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.notification-option {
    display: flex;
    align-items: center;
    padding: 12px;
    border: 1px solid var(--border-color);
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.notification-option:hover {
    background-color: var(--hover-bg);
}

.notification-option input[type="checkbox"] {
    margin-right: 12px;
}

.notification-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 12px;
    color: white;
    font-size: 16px;
}

.notification-icon.breaking {
    background-color: #dc3545;
}

.notification-icon.daily {
    background-color: #007bff;
}

.notification-icon.weekly {
    background-color: #28a745;
}

.notification-icon.marketing {
    background-color: #ffc107;
    color: #000;
}

.notification-details {
    flex: 1;
}

.notification-name {
    display: block;
    font-weight: 600;
    margin-bottom: 2px;
}

.notification-desc {
    display: block;
    font-size: 14px;
    color: var(--text-secondary);
}


.quiet-hours {
    display: flex;
    gap: 16px;
    align-items: center;
}

.time-input-group {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.time-input-group label {
    font-size: 14px;
    font-weight: 500;
}

.time-input-group input[type="time"] {
    padding: 8px 12px;
    border: 1px solid var(--border-color);
    border-radius: 6px;
    background-color: var(--bg-primary);
    color: var(--text-primary);
    font-size: 14px;
}

/* Page Content */
.page-content {
    margin-bottom: 2rem;
}

/* Preferences Form */
.preferences-form {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

/* Preference Sections */
.preference-section {
    background: var(--bg-secondary);
    border-radius: 16px;
    border: 1px solid var(--border-color);
    box-shadow: var(--card-shadow);
    padding: 1.5rem;
}

.section-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 1.5rem 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

/* Preference Groups */
.preference-group {
    margin-bottom: 1.5rem;
}

.preference-group:last-child {
    margin-bottom: 0;
}

.preference-label {
    display: block;
    font-size: 0.9rem;
    font-weight: 500;
    color: var(--text-primary);
    margin-bottom: 0.75rem;
}

/* Theme Options */
.theme-options {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
}

.theme-option {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
    cursor: pointer;
    padding: 1rem;
    border-radius: 12px;
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.theme-option:hover {
    background: rgba(255, 107, 53, 0.05);
}

.theme-option input[type="radio"] {
    display: none;
}

.theme-option input[type="radio"]:checked + .theme-preview {
    border-color: var(--accent-color);
}

.theme-option input[type="radio"]:checked ~ .theme-name {
    color: var(--accent-color);
    font-weight: 600;
}

.theme-preview {
    width: 60px;
    height: 40px;
    border-radius: 8px;
    border: 2px solid var(--border-color);
    overflow: hidden;
    transition: all 0.3s ease;
}

.theme-preview.dark {
    background: #1a1a1a;
}

.theme-preview.light {
    background: #ffffff;
}

.theme-preview.auto {
    background: linear-gradient(45deg, #1a1a1a 50%, #ffffff 50%);
}

.theme-header {
    height: 12px;
    background: var(--accent-color);
}

.theme-content {
    height: 28px;
    background: inherit;
}

.theme-name {
    font-size: 0.8rem;
    color: var(--text-secondary);
    transition: all 0.3s ease;
}

/* Font Size Options */
.font-size-options {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 1rem;
}

.font-option {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
    cursor: pointer;
    padding: 1rem;
    border-radius: 12px;
    border: 2px solid transparent;
    transition: all 0.3s ease;
}

.font-option:hover {
    background: rgba(255, 107, 53, 0.05);
}

.font-option input[type="radio"] {
    display: none;
}

.font-option input[type="radio"]:checked + .font-preview {
    color: var(--accent-color);
    font-weight: 700;
}

.font-option input[type="radio"]:checked ~ .font-name {
    color: var(--accent-color);
    font-weight: 600;
}

.font-preview {
    font-size: 1.5rem;
    color: var(--text-secondary);
    transition: all 0.3s ease;
}

.font-preview.small {
    font-size: 1.2rem;
}

.font-preview.medium {
    font-size: 1.5rem;
}

.font-preview.large {
    font-size: 1.8rem;
}

.font-name {
    font-size: 0.8rem;
    color: var(--text-secondary);
    transition: all 0.3s ease;
}

/* Preference Select */
.preference-select {
    width: 100%;
    padding: 0.75rem 1rem;
    background: var(--bg-primary);
    border: 1px solid var(--border-color);
    border-radius: 8px;
    color: var(--text-primary);
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.preference-select:focus {
    outline: none;
    border-color: var(--accent-color);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

/* Preference Switches */
.preference-switch {
    display: flex;
    align-items: center;
    gap: 1rem;
    cursor: pointer;
    padding: 0.75rem 0;
}

.preference-switch input[type="checkbox"] {
    display: none;
}

.switch-slider {
    width: 48px;
    height: 24px;
    background: var(--border-color);
    border-radius: 12px;
    position: relative;
    transition: all 0.3s ease;
}

.switch-slider::before {
    content: '';
    position: absolute;
    top: 2px;
    left: 2px;
    width: 20px;
    height: 20px;
    background: white;
    border-radius: 50%;
    transition: all 0.3s ease;
}

.preference-switch input[type="checkbox"]:checked + .switch-slider {
    background: var(--accent-color);
}

.preference-switch input[type="checkbox"]:checked + .switch-slider::before {
    transform: translateX(24px);
}

.switch-label {
    font-size: 0.9rem;
    color: var(--text-primary);
    font-weight: 500;
}

/* Form Actions */
.form-actions {
    display: flex;
    justify-content: center;
    margin-top: 1rem;
}

.btn {
    padding: 0.75rem 2rem;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
}

.btn-primary {
    background: var(--accent-gradient);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: var(--card-shadow-hover);
}

/* Responsive Design */
@media (max-width: 480px) {
    .mobile-page {
        padding: 0.75rem;
    }
    
    .theme-options,
    .font-size-options {
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    
    .theme-option,
    .font-option {
        flex-direction: row;
        justify-content: flex-start;
        text-align: left;
    }
}

/* Interests Grid */
.interests-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
    gap: 0.75rem;
    margin-top: 0.75rem;
}

.interest-option {
    display: flex;
    align-items: center;
    padding: 0.75rem;
    background: var(--bg-secondary);
    border: 1px solid var(--border-color);
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.interest-option:hover {
    background: var(--accent-color);
    color: white;
    border-color: var(--accent-color);
}

.interest-option input[type="checkbox"] {
    margin-right: 0.5rem;
    accent-color: var(--accent-color);
}

.interest-option input[type="checkbox"]:checked + .interest-label {
    font-weight: 600;
}

.interest-label {
    font-size: 0.875rem;
    font-weight: 500;
}

@media (min-width: 768px) {
    .mobile-page {
        max-width: 600px;
        margin: 0 auto;
    }
    
    .interests-grid {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Theme preview functionality
    const themeOptions = document.querySelectorAll('input[name="theme"]');
    themeOptions.forEach(option => {
        option.addEventListener('change', function() {
            // Update the page theme for preview
            if (this.value === 'dark') {
                document.documentElement.setAttribute('data-theme', 'dark');
            } else if (this.value === 'light') {
                document.documentElement.removeAttribute('data-theme');
            } else {
                // Auto theme - use system preference
                if (window.matchMedia('(prefers-color-scheme: dark)').matches) {
                    document.documentElement.setAttribute('data-theme', 'dark');
                } else {
                    document.documentElement.removeAttribute('data-theme');
                }
            }
        });
    });
    
    // Font size preview
    const fontOptions = document.querySelectorAll('input[name="font_size"]');
    fontOptions.forEach(option => {
        option.addEventListener('change', function() {
            // Apply font size to body for preview
            document.body.style.fontSize = this.value === 'small' ? '14px' : 
                                          this.value === 'large' ? '18px' : '16px';
        });
    });
    
    // Form is ready for submission
    console.log('Preferences form loaded successfully');
});
</script>
@endsection


