<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Simple OneSignal Test</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
        .status { padding: 10px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; color: #155724; }
        .error { background: #f8d7da; color: #721c24; }
        .info { background: #d1ecf1; color: #0c5460; }
        button { padding: 10px 20px; margin: 5px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .code { background: #f8f9fa; padding: 10px; border-radius: 5px; font-family: monospace; margin: 10px 0; }
    </style>
</head>
<body>
    <h1>🔔 Simple OneSignal Test</h1>
    
    <div id="status">Loading OneSignal...</div>
    <div id="player-info" style="display: none;">
        <h3>Your Player ID:</h3>
        <div class="code" id="player-id"></div>
        <button onclick="requestPermission()">Request Permission</button>
        <button onclick="sendTest()">Send Test Notification</button>
    </div>
    
    <div id="debug">
        <h3>Debug Info:</h3>
        <div class="code" id="debug-info"></div>
    </div>

    <script src="https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js"></script>
    <script>
        const appId = "{{ config('services.onesignal.app_id') }}";
        let playerId = null;
        
        function updateStatus(message, type = 'info') {
            document.getElementById('status').innerHTML = `<div class="status ${type}">${message}</div>`;
        }
        
        function updateDebug() {
            document.getElementById('debug-info').innerHTML = `
App ID: ${appId}
Player ID: ${playerId || 'Not available'}
OneSignal Available: ${typeof OneSignal !== 'undefined' ? 'Yes' : 'No'}
Window.OneSignal: ${typeof window.OneSignal !== 'undefined' ? 'Yes' : 'No'}
            `;
        }
        
        // Check if OneSignal loaded
        function checkOneSignal() {
            if (typeof OneSignal === 'undefined') {
                updateStatus('❌ OneSignal SDK failed to load', 'error');
                updateDebug();
                return false;
            }
            return true;
        }
        
        // Initialize OneSignal
        function initOneSignal() {
            if (!checkOneSignal()) return;
            
            updateStatus('🔄 Initializing OneSignal...', 'info');
            updateDebug();
            
            try {
                window.OneSignal = window.OneSignal || [];
                OneSignal.push(function() {
                    console.log('OneSignal SDK loaded');
                    
                    OneSignal.init({
                        appId: appId,
                        allowLocalhostAsSecureOrigin: true,
                        subdomainName: "mewsai",
                        notifyButton: {
                            enable: false
                        }
                    }).then(function() {
                        console.log('OneSignal initialized');
                        updateStatus('✅ OneSignal initialized!', 'success');
                        
                        // Get player ID
                        OneSignal.getUserId().then(function(userId) {
                            console.log('Player ID:', userId);
                            if (userId) {
                                playerId = userId;
                                document.getElementById('player-id').textContent = userId;
                                document.getElementById('player-info').style.display = 'block';
                                updateStatus('✅ OneSignal ready! Player ID: ' + userId, 'success');
                            } else {
                                updateStatus('⚠️ OneSignal ready, but no player ID yet. Click "Request Permission"', 'info');
                                document.getElementById('player-info').style.display = 'block';
                            }
                            updateDebug();
                        });
                    }).catch(function(error) {
                        console.error('OneSignal init error:', error);
                        updateStatus('❌ OneSignal initialization failed: ' + error.message, 'error');
                        updateDebug();
                    });
                });
            } catch (error) {
                console.error('OneSignal setup error:', error);
                updateStatus('❌ OneSignal setup failed: ' + error.message, 'error');
                updateDebug();
            }
        }
        
        function requestPermission() {
            if (!checkOneSignal()) return;
            
            OneSignal.showNativePrompt().then(function() {
                updateStatus('✅ Permission granted! Refreshing...', 'success');
                setTimeout(() => location.reload(), 1000);
            }).catch(function(error) {
                updateStatus('❌ Permission request failed: ' + error.message, 'error');
            });
        }
        
        function sendTest() {
            if (!playerId) {
                updateStatus('❌ No player ID available', 'error');
                return;
            }
            
            updateStatus('🔄 Sending test notification...', 'info');
            
            fetch('/api/test-notification', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                },
                body: JSON.stringify({
                    player_id: playerId,
                    title: 'Test Notification',
                    message: 'This is a test from Mews!'
                })
            }).then(response => response.json())
            .then(data => {
                if (data.success) {
                    updateStatus('✅ Test notification sent!', 'success');
                } else {
                    updateStatus('❌ Failed: ' + data.message, 'error');
                }
            }).catch(error => {
                updateStatus('❌ Error: ' + error.message, 'error');
            });
        }
        
        // Start when page loads
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Page loaded, starting OneSignal test...');
            updateDebug();
            
            // Wait for SDK to load
            setTimeout(initOneSignal, 1000);
        });
        
        // Update debug info every 2 seconds
        setInterval(updateDebug, 2000);
    </script>
</body>
</html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Simple OneSignal Test</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
        .status { padding: 10px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; color: #155724; }
        .error { background: #f8d7da; color: #721c24; }
        .info { background: #d1ecf1; color: #0c5460; }
        button { padding: 10px 20px; margin: 5px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .code { background: #f8f9fa; padding: 10px; border-radius: 5px; font-family: monospace; margin: 10px 0; }
    </style>
</head>
<body>
    <h1>🔔 Simple OneSignal Test</h1>
    
    <div id="status">Loading OneSignal...</div>
    <div id="player-info" style="display: none;">
        <h3>Your Player ID:</h3>
        <div class="code" id="player-id"></div>
        <button onclick="requestPermission()">Request Permission</button>
        <button onclick="sendTest()">Send Test Notification</button>
    </div>
    
    <div id="debug">
        <h3>Debug Info:</h3>
        <div class="code" id="debug-info"></div>
    </div>

    <script src="https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js"></script>
    <script>
        const appId = "{{ config('services.onesignal.app_id') }}";
        let playerId = null;
        
        function updateStatus(message, type = 'info') {
            document.getElementById('status').innerHTML = `<div class="status ${type}">${message}</div>`;
        }
        
        function updateDebug() {
            document.getElementById('debug-info').innerHTML = `
App ID: ${appId}
Player ID: ${playerId || 'Not available'}
OneSignal Available: ${typeof OneSignal !== 'undefined' ? 'Yes' : 'No'}
Window.OneSignal: ${typeof window.OneSignal !== 'undefined' ? 'Yes' : 'No'}
            `;
        }
        
        // Check if OneSignal loaded
        function checkOneSignal() {
            if (typeof OneSignal === 'undefined') {
                updateStatus('❌ OneSignal SDK failed to load', 'error');
                updateDebug();
                return false;
            }
            return true;
        }
        
        // Initialize OneSignal
        function initOneSignal() {
            if (!checkOneSignal()) return;
            
            updateStatus('🔄 Initializing OneSignal...', 'info');
            updateDebug();
            
            try {
                window.OneSignal = window.OneSignal || [];
                OneSignal.push(function() {
                    console.log('OneSignal SDK loaded');
                    
                    OneSignal.init({
                        appId: appId,
                        allowLocalhostAsSecureOrigin: true,
                        subdomainName: "mewsai",
                        notifyButton: {
                            enable: false
                        }
                    }).then(function() {
                        console.log('OneSignal initialized');
                        updateStatus('✅ OneSignal initialized!', 'success');
                        
                        // Get player ID
                        OneSignal.getUserId().then(function(userId) {
                            console.log('Player ID:', userId);
                            if (userId) {
                                playerId = userId;
                                document.getElementById('player-id').textContent = userId;
                                document.getElementById('player-info').style.display = 'block';
                                updateStatus('✅ OneSignal ready! Player ID: ' + userId, 'success');
                            } else {
                                updateStatus('⚠️ OneSignal ready, but no player ID yet. Click "Request Permission"', 'info');
                                document.getElementById('player-info').style.display = 'block';
                            }
                            updateDebug();
                        });
                    }).catch(function(error) {
                        console.error('OneSignal init error:', error);
                        updateStatus('❌ OneSignal initialization failed: ' + error.message, 'error');
                        updateDebug();
                    });
                });
            } catch (error) {
                console.error('OneSignal setup error:', error);
                updateStatus('❌ OneSignal setup failed: ' + error.message, 'error');
                updateDebug();
            }
        }
        
        function requestPermission() {
            if (!checkOneSignal()) return;
            
            OneSignal.showNativePrompt().then(function() {
                updateStatus('✅ Permission granted! Refreshing...', 'success');
                setTimeout(() => location.reload(), 1000);
            }).catch(function(error) {
                updateStatus('❌ Permission request failed: ' + error.message, 'error');
            });
        }
        
        function sendTest() {
            if (!playerId) {
                updateStatus('❌ No player ID available', 'error');
                return;
            }
            
            updateStatus('🔄 Sending test notification...', 'info');
            
            fetch('/api/test-notification', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                },
                body: JSON.stringify({
                    player_id: playerId,
                    title: 'Test Notification',
                    message: 'This is a test from Mews!'
                })
            }).then(response => response.json())
            .then(data => {
                if (data.success) {
                    updateStatus('✅ Test notification sent!', 'success');
                } else {
                    updateStatus('❌ Failed: ' + data.message, 'error');
                }
            }).catch(error => {
                updateStatus('❌ Error: ' + error.message, 'error');
            });
        }
        
        // Start when page loads
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Page loaded, starting OneSignal test...');
            updateDebug();
            
            // Wait for SDK to load
            setTimeout(initOneSignal, 1000);
        });
        
        // Update debug info every 2 seconds
        setInterval(updateDebug, 2000);
    </script>
</body>
</html>
