<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>News Chatbot - AI News Assistant</title>
    
    <!-- Open Graph Meta Tags for Social Media Sharing -->
    <meta property="og:title" content="Mews AI - AI-Powered News Chatbot">
    <meta property="og:description" content="Discover personalized news with Mews AI. Get intelligent insights, analysis, and stay informed with our AI-powered news chatbot.">
    <meta property="og:image" content="{{ asset('assets/images/mews.png') }}">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="Mews AI - AI-Powered News Chatbot">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="Mews AI">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Mews AI - AI-Powered News Chatbot">
    <meta name="twitter:description" content="Discover personalized news with Mews AI. Get intelligent insights, analysis, and stay informed with our AI-powered news chatbot.">
    <meta name="twitter:image" content="{{ asset('assets/images/mews.png') }}">
    <meta name="twitter:image:alt" content="Mews AI - AI-Powered News Chatbot">
    
    <!-- Additional Meta Tags -->
    <meta name="description" content="Discover personalized news with Mews AI. Get intelligent insights, analysis, and stay informed with our AI-powered news chatbot.">
    <meta name="keywords" content="news, AI, chatbot, personalized news, Ghana news, AI analysis, news discovery">
    
    <!-- PWA Meta Tags -->
    <meta name="application-name" content="Mews">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Mews">
    <meta name="description" content="AI-powered news chatbot for personalized news discovery">
    <meta name="format-detection" content="telephone=no">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="msapplication-config" content="{{ asset('browserconfig.xml') }}">
    <meta name="msapplication-TileColor" content="#0a57d4">
    <meta name="msapplication-tap-highlight" content="no">
    <meta name="theme-color" content="#0a57d4">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="{{ asset('manifest.json') }}">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="{{ asset('assets/images/logo/apple-touch-icon-180x180.png') }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ asset('assets/images/logo/apple-touch-icon-152x152.png') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/images/logo/apple-touch-icon-180x180.png') }}">
    <link rel="apple-touch-icon" sizes="167x167" href="{{ asset('assets/images/logo/apple-touch-icon-167x167.png') }}">
    
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('assets/images/logo/favicon.png') }}">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Feather Icons -->
    <link href="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.css" rel="stylesheet">
    
    <style>
        :root {
            --bg-primary: #ffffff;
            --bg-secondary: #f3f7fe   /* soft blue-white */;
            --text-primary: #333333;
            --text-secondary: #666666;
            --accent-color: #0a57d4;
            --accent-gradient: linear-gradient(135deg, #0a57d4 0%, #2d72f0 100%);
            --accent-hover: linear-gradient(135deg, #083a8f 0%, #1e4a9a 100%);
            --border-color: #dee2e6;
            --card-shadow: 0 8px 32px rgba(10, 87, 212, 0.1);   /* based on #0a57d4 */
            --card-shadow-hover: 0 12px 40px rgba(10, 87, 212, 0.2);   /* based on #0a57d4 */
        }
        
        [data-theme="dark"] {
            --bg-primary: #1a1a1a;
            --bg-secondary: #2d2d2d;
            --text-primary: #ffffff;
            --text-secondary: #b3b3b3;
            --border-color: #404040;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.15);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.25);
        }
        
        * {
            box-sizing: border-box;
        }
        
        body {
            background-color: var(--bg-primary);
            color: var(--text-primary);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            transition: all 0.3s ease;
            overflow-x: hidden;
            overscroll-behavior: none;
            overscroll-behavior-x: none;
            overscroll-behavior-y: auto;
            -webkit-overflow-scrolling: touch;
            touch-action: pan-y;
        }
        
        html {
            overscroll-behavior: none;
            overscroll-behavior-x: none;
            overscroll-behavior-y: auto;
        }
        
        /* Prevent horizontal scrolling and swipe gestures */
        .chat-container {
            overscroll-behavior-x: none;
            touch-action: pan-y;
        }
        
        .chat-box-list {
            overscroll-behavior-x: none;
            touch-action: pan-y;
        }
        
        /* Chatbot Controls */
        .chatbot-controls {
            position: fixed;
            top: 15px;
            right: 15px;
            display: flex;
            gap: 10px;
            z-index: 1000;
        }
        
        .chatbot-controls.logged-in {
            flex-direction: row;
        }
        
        .chatbot-controls.guest {
            flex-direction: row;
        }
        
        .clear-chat-btn,
        .theme-toggle,
        .account-btn,
        .login-btn {
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 50px;
            padding: 8px;
            color: var(--text-primary);
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: var(--card-shadow);
            font-size: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            width: 40px;
            height: 40px;
        }
        
        .clear-chat-btn {
            background: rgba(220, 53, 69, 0.1);
            border-color: rgba(220, 53, 69, 0.3);
            color: #1d4ed8;
        }
        
        .clear-chat-btn:hover {
            background: #1d4ed8;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(220, 53, 69, 0.3);
        }
        
        .theme-toggle:hover {
            background: var(--accent-gradient);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--card-shadow-hover);
        }
        
        .account-btn:hover,
        .login-btn:hover {
            background: var(--accent-gradient);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--card-shadow-hover);
        }
        
        /* Small variant for guest controls */
        .clear-chat-btn.small,
        .theme-toggle.small {
            width: 36px;
            height: 36px;
            padding: 6px;
        }





        @media (max-width: 768px) {
            .chatbot-controls {
                top: 10px;
                right: 10px;
            }
            
            .chatbot-controls.guest {
                gap: 8px;
            }
        }
        
        .chat-container {
            max-width: 100%;
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
            position: relative;
            overflow: hidden;
        }
        

        

        
        .chat-box-list {
            flex: 1;
            overflow-y: auto;
            padding: 15px;
            padding-bottom: 20px;
            margin-top: 20px; /* Space from top since no header */
            /* Remove margin-bottom as we now use proper flex layout */
        }
        
        .chat-box {
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            padding: 15px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
            box-shadow: var(--card-shadow);
        }
        
        .chat-box:hover {
            box-shadow: var(--card-shadow-hover);
            transform: translateY(-2px);
        }
        
        .chat-section {
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }
        
        .author img {
            width: 35px;
            height: 35px;
            border-radius: 50%;
            object-fit: cover;
            flex-shrink: 0;
        }
        
        .chat-content {
            flex: 1;
            min-width: 0; /* Prevents flex item from overflowing */
        }
        
        .chat-content .title {
            background: var(--accent-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 8px;
            font-weight: 600;
            font-size: 16px;
        }
        
        .chat-content p {
            color: var(--text-primary);
            line-height: 1.6;
            margin-bottom: 12px;
            font-size: 14px;
        }
        
        .news-cards {
            margin-top: 15px;
            display: grid;
            grid-template-columns: 1fr;
            gap: 15px;
        }
        
        @media (min-width: 768px) {
            .news-cards {
                grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            }
        }
        
        .news-card {
            background: var(--bg-primary);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            overflow: hidden;
            transition: all 0.3s ease;
            display: flex;
            flex-direction: column;
            box-shadow: var(--card-shadow);
            cursor: pointer;
            position: relative;
        }
        
        .news-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--card-shadow-hover);
        }
        
        .news-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: var(--accent-gradient);
            opacity: 0;
            transition: opacity 0.3s ease;
            z-index: 1;
            pointer-events: none;
        }
        
        .news-card:hover::before {
            opacity: 0.05;
        }
        
        .news-card-image {
            width: 100%;
            height: 180px;
            position: relative;
            overflow: hidden;
        }
        
        .news-card-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s ease;
        }
        
        .news-card:hover .news-card-image img {
            transform: scale(1.05);
        }
        
        .news-card-category-overlay {
            position: absolute;
            top: 10px;
            left: 10px;
            background: var(--accent-gradient);
            color: white;
            padding: 4px 8px;
            border-radius: 8px;
            font-size: 10px;
            font-weight: 600;
            z-index: 10;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
        }
        
        .news-card-content-wrapper {
            padding: 12px;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            position: relative;
            z-index: 2;
        }
        
        .news-title {
            color: var(--text-primary);
            margin: 0 0 8px 0;
            font-size: 16px;
            font-weight: 600;
            line-height: 1.4;
        }
        
        .news-card-content p {
            color: var(--text-secondary);
            font-size: 13px;
            line-height: 1.5;
            margin-bottom: 12px;
        }
        
        .news-meta {
            display: flex;
            flex-direction: column;
            gap: 8px;
            font-size: 11px;
            color: var(--text-secondary);
            margin-top: auto;
            padding-top: 10px;
            border-top: 1px solid var(--border-color);
        }
        
        .news-meta-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .news-date, .news-views {
            display: flex;
            align-items: center;
            gap: 4px;
        }
        
        .news-source {
            background: var(--accent-gradient);
            color: white;
            text-decoration: none;
            font-weight: 600;
            padding: 6px 12px;
            border-radius: 6px;
            font-size: 12px;
            transition: all 0.3s ease;
            text-align: center;
            display: inline-block;
        }
        
        .news-source:hover {
            background: var(--accent-hover);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--card-shadow-hover);
        }
        
        .chat-input-container {
            background: var(--bg-secondary);
            border-top: 1px solid var(--border-color);
            padding: 15px;
            position: relative;
            flex-shrink: 0;
            z-index: 100;
            backdrop-filter: blur(10px);
        }
        
        .chat-form {
            display: flex;
            gap: 10px;
            align-items: flex-end;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .chat-textarea {
            flex: 1;
            background: var(--bg-primary);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            padding: 12px;
            color: var(--text-primary);
            resize: none;
            min-height: 45px;
            max-height: 120px;
            font-size: 14px;
        }
        
        .chat-textarea:focus {
            outline: none;
            border-color: var(--accent-color);
            box-shadow: 0 0 0 3px rgba(10, 87, 212, 0.1);
        }
        
        .send-button {
            background: var(--accent-gradient);
            color: white;
            border: none;
            border-radius: 10px;
            padding: 12px 20px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 14px;
            white-space: nowrap;
            box-shadow: var(--card-shadow);
        }
        
        .send-button:hover {
            background: var(--accent-hover);
            transform: translateY(-2px);
            box-shadow: var(--card-shadow-hover);
        }
        
        .send-button:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .loading-message {
            text-align: center;
            color: var(--text-secondary);
            font-style: italic;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        
        .spinner-border {
            color: var(--accent-color) !important;
        }
        
        .thinking-indicator {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 4px;
            margin: 10px 0;
        }
        
        .thinking-dot {
            width: 8px;
            height: 8px;
            background: var(--accent-color);
            border-radius: 50%;
            animation: thinking 1.4s infinite ease-in-out;
        }
        
        .thinking-dot:nth-child(1) { animation-delay: -0.32s; }
        .thinking-dot:nth-child(2) { animation-delay: -0.16s; }
        
        @keyframes thinking {
            0%, 80%, 100% {
                transform: scale(0.8);
                opacity: 0.5;
            }
            40% {
                transform: scale(1);
                opacity: 1;
            }
        }
        
        .typing-cursor {
            color: var(--accent-color);
            font-weight: bold;
            animation: blink 1s infinite;
        }
        
        @keyframes blink {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0; }
        }
        
        .thinking-indicator {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 4px;
            margin: 10px 0;
        }
        
        .thinking-dot {
            width: 8px;
            height: 8px;
            background: var(--accent-color);
            border-radius: 50%;
            animation: thinking 1.4s infinite ease-in-out;
        }
        
        .thinking-dot:nth-child(1) { animation-delay: -0.32s; }
        .thinking-dot:nth-child(2) { animation-delay: -0.16s; }
        
        @keyframes thinking {
            0%, 80%, 100% {
                transform: scale(0.8);
                opacity: 0.5;
            }
            40% {
                transform: scale(1);
                opacity: 1;
            }
        }
        
        /* Ad Display Styles */
        .ad-container {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            border: 2px solid #dee2e6;
            border-radius: 15px;
            padding: 20px;
            margin: 15px 0;
            text-align: center;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            position: relative;
            cursor: pointer;
        }
        
        [data-theme="dark"] .ad-container {
            background: linear-gradient(135deg, #2d2d2d, #1a1a1a);
            border-color: #404040;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        }
        
        .ad-container:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
            background: linear-gradient(135deg, #e9ecef, #dee2e6);
        }
        
        [data-theme="dark"] .ad-container:hover {
            background: linear-gradient(135deg, #404040, #2d2d2d);
        }
        
        .ad-label {
            font-size: 0.75rem;
            color: #6c757d;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 10px;
            font-weight: 600;
        }
        
        [data-theme="dark"] .ad-label {
            color: #adb5bd;
        }
        
        .ad-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #212529;
            line-height: 1.3;
            margin-bottom: 8px;
        }
        
        [data-theme="dark"] .ad-title {
            color: #f8f9fa;
        }
        
        .ad-content {
            font-size: 0.9rem;
            color: #495057;
            line-height: 1.4;
            margin-bottom: 15px;
        }
        
        [data-theme="dark"] .ad-content {
            color: #ced4da;
        }
        
        .ad-cta {
            background: linear-gradient(135deg, #0a57d4, #147EF3);
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
        }
        
        .ad-cta:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(10, 87, 212, 0.3);
            color: white;
            text-decoration: none;
        }
        
        .ad-close {
            position: absolute;
            top: 8px;
            right: 8px;
            background: rgba(0, 0, 0, 0.1);
            border: none;
            border-radius: 50%;
            width: 24px;
            height: 24px;
            cursor: pointer;
            color: #6c757d;
            font-size: 12px;
            transition: all 0.3s ease;
        }
        
        .ad-close:hover {
            background: rgba(0, 0, 0, 0.2);
            color: #495057;
        }
        
        [data-theme="dark"] .ad-container {
            background: linear-gradient(135deg, #2d2d2d, #1a1a1a);
            border-color: #404040;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        }
        
        [data-theme="dark"] .ad-close {
            background: rgba(255, 255, 255, 0.1);
            color: #adb5bd;
        }
        
        [data-theme="dark"] .ad-close:hover {
            background: rgba(255, 255, 255, 0.2);
            color: #ced4da;
        }
        
        /* Custom scrollbar */
        .chat-box-list::-webkit-scrollbar {
            width: 6px;
        }
        
        .chat-box-list::-webkit-scrollbar-track {
            background: var(--bg-primary);
            border-radius: 3px;
        }
        
        .chat-box-list::-webkit-scrollbar-thumb {
            background: var(--accent-gradient);
            border-radius: 3px;
        }
        
        .chat-box-list::-webkit-scrollbar-thumb:hover {
            background: var(--accent-hover);
        }
        
        /* Mobile optimizations */
        @media (max-width: 768px) {
            .theme-toggle {
                top: 10px;
                right: 10px;
                padding: 6px 12px;
                font-size: 12px;
            }
            

            
            .chat-box-list {
                padding: 10px;
                padding-bottom: 15px;
            }
            
            .chat-box {
                padding: 12px;
                margin-bottom: 12px;
            }
            
            .chat-section {
                gap: 10px;
            }
            
            .author img {
                width: 30px;
                height: 30px;
            }
            
            .news-cards {
                gap: 12px;
            }
            
            .news-card-image {
                height: 160px;
            }
            
            .news-card-content-wrapper {
                padding: 10px;
            }
            
            .news-title {
                font-size: 15px;
            }
            
            .news-card-content p {
                font-size: 12px;
            }
            
            .chat-input-container {
                padding: 12px 10px;
            }
            
            .chat-form {
                gap: 8px;
            }
            
            .chat-textarea {
                padding: 10px;
                font-size: 13px;
            }
            
            .send-button {
                padding: 10px 16px;
                font-size: 13px;
            }
            
            .category-buttons-container {
                padding: 12px 10px;
            }
            
            
            .category-buttons {
                gap: 6px;
            }
            
            .category-tag {
                padding: 6px 12px;
                font-size: 12px;
            }
            

        }
        
        /* Small mobile devices */
        @media (max-width: 480px) {
            
            .news-cards {
                grid-template-columns: 1fr;
            }
            
            .news-meta {
                flex-direction: column;
                gap: 6px;
            }
            
            .news-meta-row {
                justify-content: space-between;
            }
            
            .category-buttons {
                justify-content: space-around;
            }
            
            .category-tag {
                padding: 8px 12px;
                font-size: 11px;
            }
        }
        
        /* Landscape mobile */
        @media (max-height: 500px) and (orientation: landscape) {
            

            
            
        }
        
        /* High DPI displays */
        @media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
            .news-card-image img {
                image-rendering: -webkit-optimize-contrast;
                image-rendering: crisp-edges;
            }
        }
        
        /* Dark mode enhancements */
        [data-theme="light"] .news-card {
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }
        
        [data-theme="light"] .news-card:hover {
            box-shadow: 0 8px 30px rgba(0,0,0,0.12);
        }
        
        /* Focus states for accessibility */
        .category-tag:focus,
        .send-button:focus,
        .chat-textarea:focus {
            outline: 2px solid var(--accent-color);
            outline-offset: 2px;
        }
        
        /* Smooth animations */
        .chat-box,
        .news-card,
        .category-tag,
        .send-button {
            will-change: transform, box-shadow;
        }

        .category-buttons-container {
            background: var(--bg-secondary);
            border-top: 1px solid var(--border-color);
            padding: 15px;
            position: relative;
            flex-shrink: 0;
            z-index: 100;
            backdrop-filter: blur(10px);
        }
        
        
        /* Loading Indicators */
        .loading-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
            margin-right: 8px;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .btn-loading {
            opacity: 0.7;
            pointer-events: none;
            position: relative;
        }
        
        .btn-loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 16px;
            height: 16px;
            margin: -8px 0 0 -8px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }
        
        .btn-loading .btn-text {
            opacity: 0;
        }
        
        /* Subtle loading overlay */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(2px);
            z-index: 9999;
            display: none;
            align-items: center;
            justify-content: center;
        }
        
        .loading-overlay.show {
            display: flex;
        }
        
        .loading-content {
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            box-shadow: var(--card-shadow);
        }
        
        .loading-content .loading-spinner {
            width: 24px;
            height: 24px;
            margin: 0 0 12px 0;
        }
        
        .loading-content .loading-text {
            color: var(--text-primary);
            font-size: 14px;
            font-weight: 500;
        }

        /* PWA Install Prompt */
        .pwa-install-prompt {
            position: fixed;
            bottom: 20px;
            left: 20px;
            right: 20px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: var(--text-primary);
            padding: 20px;
            border-radius: 16px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            z-index: 1000;
            display: none;
            animation: slideUp 0.3s ease-out;
        }
        
        [data-theme="light"] .pwa-install-prompt {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(0, 0, 0, 0.1);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }
        
        .pwa-install-prompt.show {
            display: block;
        }
        
        .pwa-install-prompt .install-content {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .pwa-install-prompt .install-icon {
            width: 50px;
            height: 50px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            flex-shrink: 0;
            overflow: hidden;
        }
        
        .pwa-install-prompt .install-avatar {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 12px;
        }
        
        .pwa-install-prompt .install-text {
            flex: 1;
        }
        
        .pwa-install-prompt .install-title {
            font-size: 16px;
            font-weight: 700;
            margin: 0 0 4px 0;
            color: var(--text-primary);
        }
        
        .pwa-install-prompt .install-subtitle {
            font-size: 14px;
            opacity: 0.8;
            margin: 0;
            color: var(--text-secondary);
        }
        
        .pwa-install-prompt .install-actions {
            display: flex;
            gap: 10px;
            margin-top: 15px;
        }
        
        .pwa-install-prompt .install-btn {
            background: var(--accent-color);
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 10px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            flex: 1;
            font-size: 14px;
        }
        
        .pwa-install-prompt .install-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(10, 87, 212, 0.3);
        }
        
        .pwa-install-prompt .dismiss-btn {
            background: rgba(255, 255, 255, 0.1);
            color: var(--text-primary);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 12px 16px;
            border-radius: 10px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 14px;
        }
        
        .pwa-install-prompt .dismiss-btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        
        [data-theme="light"] .pwa-install-prompt .dismiss-btn {
            background: rgba(0, 0, 0, 0.1);
            color: var(--text-primary);
            border: 1px solid rgba(0, 0, 0, 0.2);
        }
        
        [data-theme="light"] .pwa-install-prompt .dismiss-btn:hover {
            background: rgba(0, 0, 0, 0.2);
        }
        
        @keyframes slideUp {
            from {
                transform: translateY(100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        /* Mobile specific styles */
        @media (max-width: 768px) {
            .pwa-install-prompt {
                left: 15px;
                right: 15px;
                bottom: 15px;
                padding: 18px;
            }
            
            .pwa-install-prompt .install-content {
                gap: 12px;
            }
            
            .pwa-install-prompt .install-icon {
                width: 45px;
                height: 45px;
                font-size: 20px;
            }
        }
        
        .category-buttons {
            display: flex;
            gap: 8px;
            justify-content: flex-start;
            max-width: 800px;
            margin: 0 auto;
            overflow-x: auto;
            scrollbar-width: none; /* Firefox */
            -ms-overflow-style: none; /* IE and Edge */
            padding-bottom: 5px; /* Space for scrollbar */
            scroll-snap-type: x mandatory;
            scroll-behavior: smooth;
        }
        
        .category-buttons::-webkit-scrollbar {
            display: none; /* Chrome, Safari, Opera */
        }
        
        .category-tag {
            background: var(--accent-gradient);
            color: white;
            padding: 8px 16px;
            border-radius: 25px;
            font-size: 13px;
            cursor: pointer;
            transition: all 0.3s ease;
            user-select: none;
            border: none;
            white-space: nowrap;
            box-shadow: var(--card-shadow);
            font-weight: 500;
            flex-shrink: 0;
            scroll-snap-align: start;
        }
        
        .category-tag:hover {
            transform: translateY(-3px);
            box-shadow: var(--card-shadow-hover);
            background: var(--accent-hover);
        }
        
        /* Light mode specific button styling */
        [data-theme="light"] .category-tag {
            background: linear-gradient(135deg, #0a57d4 0%, #147EF3 100%);
            color: white;
            box-shadow: 0 2px 8px rgba(10, 87, 212, 0.3)   /* based on #0a57d4 */;
        }
        
        [data-theme="light"] .category-tag:hover {
            background: inear-gradient(135deg, #0a57d4 0%, #147EF3 100%);
            box-shadow: 0 4px 12px rgba(10, 87, 212, 0.3)   /* based on #0a57d4 */;
        }
        
        /* Light mode specific button styling */
        [data-theme="light"] .category-tag,
        :root:not([data-theme]) .category-tag {
            background: linear-gradient(135deg, #0a57d4 0%, #147EF3 100%);
            color: white;
            box-shadow: 0 2px 8px rgba(10, 87, 212, 0.2)   /* from #0a57d4 */;
        }
        
        [data-theme="light"] .category-tag:hover,
        :root:not([data-theme]) .category-tag:hover {
            background: inear-gradient(135deg, #0a57d4 0%, #147EF3 100%);
            box-shadow: 0 4px 12px rgba(10, 87, 212, 0.3)   /* from #0a57d4 */;
        }
        
        /* Dark mode specific button styling */
        [data-theme="dark"] .category-tag {
            background: linear-gradient(135deg, #0a57d4 0%, #147EF3 100%);
            color: white;
            box-shadow: 0 2px 8px rgba(10, 87, 212, 0.3);
        }
        
        [data-theme="dark"] .category-tag:hover {
            background: inear-gradient(135deg, #0a57d4 0%, #147EF3 100%);
            box-shadow: 0 4px 12px rgba(10, 87, 212, 0.4)   /* based on #0a57d4 */;
        }
        
    </style>
    
    <!-- Theme Manager -->
    <script src="{{ asset('js/theme-manager.js') }}"></script>
    
    <!-- Immediate theme application to prevent flash -->
    <script>
        (function() {
            const savedTheme = localStorage.getItem('theme');
            // Default to light mode if no theme is saved
            if (savedTheme === 'dark') {
                document.documentElement.setAttribute('data-theme', 'dark');
            } else {
                // Default to light mode
                document.documentElement.removeAttribute('data-theme');
                localStorage.setItem('theme', 'light');
            }
        })();
    </script>
</head>
<body>
    <!-- Chatbot Controls -->
    @auth
        <!-- Logged-in User Controls -->
        <!-- <div class="chatbot-controls logged-in">
            <button class="clear-chat-btn" onclick="clearChat()" aria-label="Clear chat history" title="Clear Chat">
                <i class="feather" data-feather="trash-2"></i>
            </button>
            <a href="{{ route('user.dashboard') }}" class="account-btn" title="Account">
                <i class="feather" data-feather="user"></i>
            </a>
        </div> -->
    @else
        <!-- Guest User Controls -->
        <!-- <div class="chatbot-controls guest">
            <button class="clear-chat-btn small" onclick="clearChat()" aria-label="Clear chat history" title="Clear Chat">
                <i class="feather" data-feather="trash-2"></i>
            </button>
            <button class="theme-toggle small" onclick="toggleTheme()" aria-label="Toggle theme" title="Theme">
                <i class="feather" data-feather="moon"></i>
            </button>
            <a href="{{ route('login') }}" class="login-btn" title="Login">
                <i class="feather" data-feather="log-in"></i>
            </a>
        </div> -->
    @endauth


    <div class="chat-container">


        <!-- Chat Messages -->
        <div class="chat-box-list" id="chatContainer">
            <!-- Welcome Message -->
            <div class="chat-box">
                <div class="chat-section">
                    <div class="author">
                        <img src="{{ asset('assets/images/team/avater.png') }}" alt="Mews" loading="lazy">
                    </div>
                    <div class="chat-content">
                        <h6 class="title">Mews <span style="background: var(--accent-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; padding: 4px 8px; border-radius: 10px; font-size: 12px;">AI</span></h6>
                        
                        @auth
                            <p>Hello {{ explode(' ', auth()->user()->name)[0] }}, welcome back! I'm your AI news assistant. Ask me about any topic like "What's new in sports?" or "Tell me about technology news" and I'll find the latest relevant articles for you!</p>
                            <p style="color: var(--text-secondary); font-size: 0.9rem;">💡 <strong>Tip:</strong> Click on any category below or type your question below to get started!</p>
                        @else
                            <p>Hello! I'm your AI news assistant. Ask me about any topic like "What's new in sports?" or "Tell me about technology news" and I'll find the latest relevant articles for you!</p>
                            <p style="color: var(--text-secondary); font-size: 0.9rem;">💡 <strong>Tip:</strong> Click on any category above or type your question below to get started!</p>
                        @endauth
                    </div>
                </div>
            </div>
        </div>

        <!-- Category Buttons -->
        <div class="category-buttons-container">
            <div class="category-buttons">
                @foreach($personalizedCategories as $category)
                    @php
                        // Map categories to emojis and clean names
                        $categoryEmojis = [
                            'politics' => '🏛️',
                            'business' => '💼',
                            'entertainment' => '🎬',
                            'sports' => '🏈',
                            'technology' => '💻',
                            'health' => '🏥',
                            'science' => '🔬',
                            'international' => '🌍',
                            'world' => '🌍',
                            'local' => '🏠',
                            'finance' => '💰',
                            'economy' => '📈',
                            'education' => '📚',
                            'environment' => '🌱',
                            'crime' => '🚨',
                            'weather' => '🌤️'
                        ];
                        
                        $categoryLower = strtolower($category);
                        $emoji = '📰'; // Default emoji
                        
                        // Find matching emoji
                        foreach($categoryEmojis as $key => $value) {
                            if(strpos($categoryLower, $key) !== false || strpos($key, $categoryLower) !== false) {
                                $emoji = $value;
                                break;
                            }
                        }
                        
                        // Clean category name for display
                        $displayName = ucwords(strtolower($category));
                    @endphp
                    <button class="category-tag" 
                            data-category="{{ strtolower($category) }}" 
                            aria-label="Get {{ $displayName }} news">
                        {{ $emoji }} {{ $displayName }}
                    </button>
                @endforeach
            </div>
        </div>

        <!-- Chat Input -->
        <div class="chat-input-container">
            <form class="chat-form" id="newsChatForm">
                @csrf
                <textarea 
                    class="chat-textarea" 
                    id="txtarea" 
                    rows="1" 
                    placeholder="Ask me about the latest news..."
                    required
                    aria-label="Type your message here"
                ></textarea>
                <button type="submit" class="send-button" id="sendButton" aria-label="Send message">
                    <i class="feather" data-feather="send"></i>
                    <span class="d-none d-sm-inline">Send</span>
                </button>
            </form>
        </div>
    </div>

    <!-- Loading Overlay -->
    <div id="loadingOverlay" class="loading-overlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <div class="loading-text" id="loadingText">Loading...</div>
        </div>
    </div>

    <!-- PWA Install Prompt -->
    <!-- <div class="pwa-install-prompt" id="pwaInstallPrompt">
        <div class="install-content">
            <div class="install-icon">
                <img src="{{ asset('assets/images/team/avater.png') }}" alt="Mews App" class="install-avatar">
            </div>
            <div class="install-text">
                <div class="install-title">Install Mews App</div>
                <div class="install-subtitle">Get quick access to AI news chatbot on your home screen</div>
            </div>
        </div>
        <div class="install-actions">
            <button class="install-btn" onclick="installPWA()">
                <i class="fas fa-download"></i> Install App
            </button>
            <button class="dismiss-btn" onclick="hideInstallPrompt()">
                <i class="fas fa-times"></i> Not Now
            </button>
        </div>
    </div> -->

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Feather Icons -->
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>

    <script>
        // PWA Install Prompt - Global functions (must be defined before DOMContentLoaded)
        let deferredPrompt;
        let installPromptShown = false;
        
        // Check if user is on mobile device
        function isMobileDevice() {
            return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) || 
                   (navigator.maxTouchPoints && navigator.maxTouchPoints > 2);
        }
        
        // Check if app is already installed
        function isAppInstalled() {
            return window.matchMedia('(display-mode: standalone)').matches || 
                   window.navigator.standalone === true;
        }
        
        // Check if user has dismissed the prompt before
        function hasUserDismissedPrompt() {
            return localStorage.getItem('pwa-install-dismissed') === 'true';
        }
        
        // Show install prompt with delay for better UX
        function showInstallPrompt() {
            if (installPromptShown || isAppInstalled() || hasUserDismissedPrompt()) {
                return;
            }
            
            // Show prompt after a short delay
            setTimeout(() => {
                const prompt = document.getElementById('pwaInstallPrompt');
                if (prompt) {
                    prompt.classList.add('show');
                    installPromptShown = true;
                }
            }, 5000); // Show after 5 seconds on chatbot page
        }
        
        function hideInstallPrompt() {
            const prompt = document.getElementById('pwaInstallPrompt');
            if (prompt) {
                prompt.classList.remove('show');
            }
            // Remember that user dismissed the prompt
            localStorage.setItem('pwa-install-dismissed', 'true');
        }
        
        // Loading indicator functions
        function showLoading(message = 'Loading...') {
            const overlay = document.getElementById('loadingOverlay');
            const text = document.getElementById('loadingText');
            text.textContent = message;
            overlay.classList.add('show');
        }
        
        function hideLoading() {
            const overlay = document.getElementById('loadingOverlay');
            overlay.classList.remove('show');
        }
        
        function setButtonLoading(button, loading = true) {
            if (loading) {
                button.classList.add('btn-loading');
                button.disabled = true;
                const text = button.querySelector('.btn-text');
                if (text) {
                    text.style.opacity = '0';
                }
            } else {
                button.classList.remove('btn-loading');
                button.disabled = false;
                const text = button.querySelector('.btn-text');
                if (text) {
                    text.style.opacity = '1';
                }
            }
        }

        function installPWA() {
            console.log('Install PWA button clicked');
            if (deferredPrompt) {
                deferredPrompt.prompt();
                deferredPrompt.userChoice.then(function(choiceResult) {
                    if (choiceResult.outcome === 'accepted') {
                        console.log('User accepted the install prompt');
                        // Track successful installation
                        localStorage.setItem('pwa-install-accepted', 'true');
                        
                        // Show success message
                        showInstallSuccess();
                    } else {
                        console.log('User dismissed the install prompt');
                        localStorage.setItem('pwa-install-dismissed', 'true');
                    }
                    deferredPrompt = null;
                });
            } else {
                // Fallback for browsers that don't support beforeinstallprompt
                showInstallInstructions();
            }
            hideInstallPrompt();
        }
        
        function showInstallSuccess() {
            // Create a temporary success message
            const successMsg = document.createElement('div');
            successMsg.innerHTML = `
                <div style="position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); 
                           background: var(--accent-color); color: white; padding: 20px; 
                           border-radius: 12px; z-index: 1001; text-align: center; box-shadow: 0 8px 32px rgba(0,0,0,0.3);">
                    <i class="fas fa-check-circle" style="font-size: 24px; margin-bottom: 10px;"></i><br>
                    <strong>App Installing!</strong><br>
                    <small>Check your home screen in a moment</small>
                </div>
            `;
            document.body.appendChild(successMsg);
            
            setTimeout(() => {
                document.body.removeChild(successMsg);
            }, 3000);
        }
        
        function showInstallInstructions() {
            // Show manual install instructions for iOS
            const instructions = document.createElement('div');
            instructions.innerHTML = `
                <div style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; 
                           background: rgba(0,0,0,0.8); z-index: 1001; display: flex; 
                           align-items: center; justify-content: center; padding: 20px;">
                    <div style="background: white; padding: 30px; border-radius: 16px; max-width: 400px; text-align: center;">
                        <i class="fas fa-mobile-alt" style="font-size: 48px; color: var(--accent-color); margin-bottom: 20px;"></i>
                        <h3 style="margin: 0 0 15px 0; color: #333;">Install Mews App</h3>
                        <p style="color: #666; margin-bottom: 20px; line-height: 1.5;">
                            Tap the <strong>Share</strong> button <i class="fas fa-share"></i> in your browser, 
                            then select <strong>"Add to Home Screen"</strong>
                        </p>
                        <button onclick="this.parentElement.parentElement.remove()" 
                                style="background: var(--accent-color); color: white; border: none; 
                                       padding: 12px 24px; border-radius: 8px; font-weight: 600; cursor: pointer;">
                            Got it!
                        </button>
                    </div>
                </div>
            `;
            document.body.appendChild(instructions);
        }
        
        // Initialize Feather Icons
        feather.replace();
        
        // Generate unique session ID for conversation context
        const sessionId = 'session_' + Date.now() + '_' + Math.random().toString(36).substr(2, 9);
        
        // Chat state management
        const CHAT_STORAGE_KEY = 'mews_chat_history';
        const SESSION_STORAGE_KEY = 'mews_session_id';
        
        // Initialize chat state
        let chatHistory = [];
        let currentSessionId = sessionId;
        
        // Chat state management functions
        function saveChatState() {
            const chatData = {
                sessionId: currentSessionId,
                history: chatHistory,
                timestamp: Date.now()
            };
            localStorage.setItem(CHAT_STORAGE_KEY, JSON.stringify(chatData));
            sessionStorage.setItem(SESSION_STORAGE_KEY, currentSessionId);
        }
        
        function loadChatState() {
            try {
                const savedData = localStorage.getItem(CHAT_STORAGE_KEY);
                const savedSessionId = sessionStorage.getItem(SESSION_STORAGE_KEY);
                
                if (savedData && savedSessionId) {
                    const chatData = JSON.parse(savedData);
                    
                    // Check if session is recent (within 24 hours)
                    const isRecent = (Date.now() - chatData.timestamp) < (24 * 60 * 60 * 1000);
                    
                    if (isRecent && chatData.sessionId === savedSessionId) {
                        currentSessionId = chatData.sessionId;
                        chatHistory = chatData.history || [];
                        
                        // Restore chat messages
                        restoreChatMessages();
                        return true;
                    }
                }
            } catch (error) {
                console.error('Error loading chat state:', error);
            }
            return false;
        }
        
        function restoreChatMessages() {
            const chatContainer = document.getElementById('chat-container');
            if (!chatContainer || chatHistory.length === 0) return;
            
            // Clear existing messages (except welcome message)
            const existingMessages = chatContainer.querySelectorAll('.chat-box');
            existingMessages.forEach(msg => {
                if (!msg.querySelector('.welcome-message')) {
                    msg.remove();
                }
            });
            
            // Restore chat history
            chatHistory.forEach(chatItem => {
                if (chatItem.type === 'user') {
                    addChatMessage('user', chatItem.message);
                } else if (chatItem.type === 'bot') {
                    addChatMessage('bot', chatItem.message, chatItem.newsData, chatItem.isNewsQuery, chatItem.queryAnalysis);
                }
            });
            
            // Scroll to bottom
            chatContainer.scrollTop = chatContainer.scrollHeight;
        }
        
        function clearChatState() {
            localStorage.removeItem(CHAT_STORAGE_KEY);
            sessionStorage.removeItem(SESSION_STORAGE_KEY);
            chatHistory = [];
        }
        
        function clearChat() {
            if (confirm('Are you sure you want to clear the chat history? This action cannot be undone.')) {
                // Clear chat state
                clearChatState();
                
                // Clear chat container (except welcome message)
                const chatContainer = document.getElementById('chatContainer');
                if (chatContainer) {
                    const existingMessages = chatContainer.querySelectorAll('.chat-box');
                    existingMessages.forEach(msg => {
                        // Keep only the welcome message (first message)
                        if (msg !== existingMessages[0]) {
                            msg.remove();
                        }
                    });
                }
                
                // Generate new session ID
                currentSessionId = 'session_' + Date.now() + '_' + Math.random().toString(36).substr(2, 9);
                
                console.log('Chat cleared successfully');
            }
        }
        
        // Ad frequency tracking
        let messageCount = 0;
        let adFrequency = '{{ $uiSettings["ad_frequency"] ?? "every" }}';
        
        // Theme Toggle Functionality
        function toggleTheme() {
            // Use centralized theme manager
            if (window.themeManager) {
                window.themeManager.toggleTheme();
                feather.replace();
            }
        }
        
        // Load saved theme and chat state
        document.addEventListener('DOMContentLoaded', function() {
            // Apply saved theme immediately to prevent flash
            applySavedTheme();
            
            // Also apply theme when page becomes visible (for back navigation)
            document.addEventListener('visibilitychange', function() {
                if (!document.hidden) {
                    applySavedTheme();
                    // Reload chat state when returning from another page
                    loadChatState();
                }
            });
            
            // Handle browser back/forward navigation
            window.addEventListener('pageshow', function(event) {
                // If page was loaded from cache (back/forward navigation)
                if (event.persisted) {
                    applySavedTheme();
                    loadChatState();
                }
            });
            
            function applySavedTheme() {
                // Theme management is now handled by the centralized ThemeManager
                // Just update the feather icons
                feather.replace();
            }
            
            // Check if user just logged in and restart PWA to prevent back navigation
            @if(session('pwa_restart'))
            if (window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone === true) {
                // User is in PWA mode and just logged in, restart the app
                console.log('PWA restart after login to prevent back navigation');
                
                // Clear any cached navigation state
                if ('serviceWorker' in navigator) {
                    navigator.serviceWorker.getRegistrations().then(function(registrations) {
                        for(let registration of registrations) {
                            registration.unregister();
                        }
                    });
                }
                
                // Force reload to restart the PWA
                setTimeout(() => {
                    window.location.reload(true);
                }, 1000);
            }
            @endif
            
            // Load chat state
            const chatStateLoaded = loadChatState();
            
            // PWA Navigation Control - Prevent back navigation on chatbot page
            // Prevent back button navigation
            window.addEventListener('popstate', function(event) {
                // Push the current state back to prevent going back
                history.pushState(null, null, location.href);
                console.log('Back navigation prevented');
            });
            
            // Push initial state to prevent back navigation
            history.pushState(null, null, location.href);
            
            // Simple back navigation prevention (keeping only the essential parts)
            window.addEventListener('popstate', function(event) {
                history.pushState(null, null, location.href);
            });
            
            // Prevent context menu on long press (can trigger back navigation on some devices)
            document.addEventListener('contextmenu', function(e) {
                e.preventDefault();
            });
            
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.ready.then(registration => {
                    // Notify service worker about navigation prevention
                    if (registration.active) {
                        const messageChannel = new MessageChannel();
                        messageChannel.port1.onmessage = function(event) {
                            console.log('PWA Navigation: Back navigation prevented');
                        };
                        registration.active.postMessage({
                            type: 'PREVENT_BACK_NAVIGATION'
                        }, [messageChannel.port2]);
                    }
                });
            }
            if (chatStateLoaded) {
                console.log('Chat state restored successfully');
            }
            
            // PWA Install Prompt functionality - Use global functions defined above
            
            // Listen for beforeinstallprompt event
            window.addEventListener('beforeinstallprompt', function(e) {
                e.preventDefault();
                deferredPrompt = e;
                
                // Only show prompt on mobile devices
                if (isMobileDevice()) {
                    showInstallPrompt();
                }
            });
            
            // Listen for app installed event
            window.addEventListener('appinstalled', function(e) {
                console.log('PWA was installed successfully');
                localStorage.setItem('pwa-install-accepted', 'true');
                hideInstallPrompt();
            });
            
            // Show prompt on page load for mobile users (if conditions are met)
            if (isMobileDevice() && !isAppInstalled() && !hasUserDismissedPrompt()) {
                // Show prompt even without beforeinstallprompt event
                showInstallPrompt();
            }
            
            // Initialize chat functionality
            initializeChat();
            
            // Auto-focus textarea on mobile
            if (window.innerWidth <= 768) {
                document.getElementById('txtarea').focus();
            }
        });
        
        function initializeChat() {
            const chatContainer = document.getElementById('chatContainer');
            const newsChatForm = document.getElementById('newsChatForm');
            const txtarea = document.getElementById('txtarea');
            
            // Category tag click handlers
            document.querySelectorAll('.category-tag').forEach(tag => {
                tag.addEventListener('click', function() {
                    const category = this.getAttribute('data-category');
                    const query = `What's the latest news in ${category}?`;
                    sendMessage(query);
                });
            });
            
            // Form submission
            newsChatForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const message = txtarea.value.trim();
                if (message) {
                    sendMessage(message);
                    txtarea.value = '';
                    // Reset textarea height
                    txtarea.style.height = 'auto';
                }
            });
            
            // Auto-resize textarea
            txtarea.addEventListener('input', function() {
                this.style.height = 'auto';
                this.style.height = Math.min(this.scrollHeight, 120) + 'px';
            });
            
            // Handle Enter key (send on Enter, new line on Shift+Enter)
            txtarea.addEventListener('keydown', function(e) {
                if (e.key === 'Enter' && !e.shiftKey) {
                    e.preventDefault();
                    newsChatForm.dispatchEvent(new Event('submit'));
                }
            });
            
            function sendMessage(message) {
                // Add user message to chat
                addChatMessage('user', message);
                
                // Show loading message
                const loadingId = addLoadingMessage();
                
                // Send to Laravel API with session ID
                fetch('{{ route("news.chat") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({ 
                        query: message,
                        session_id: currentSessionId
                    })
                })
                .then(response => response.json())
                .then(data => {
                    // Remove loading message
                    removeLoadingMessage(loadingId);
                    
                    if (data.success) {
                        // Add bot response with query analysis
                        addChatMessage('bot', data.response, data.news_data, data.is_news_query, data.query_analysis);
                    } else {
                        addChatMessage('bot', 'Sorry, I encountered an error: ' + data.error);
                    }
                })
                .catch(error => {
                    removeLoadingMessage(loadingId);
                    addChatMessage('bot', 'Sorry, I encountered an error. Please try again.');
                    console.error('Error:', error);
                });
            }
            
            function addChatMessage(type, message, newsData = null, isNewsQuery = false, queryAnalysis = null) {
                const chatBox = document.createElement('div');
                chatBox.className = 'chat-box';
                
                // Save to chat history
                chatHistory.push({
                    type: type,
                    message: message,
                    newsData: newsData,
                    isNewsQuery: isNewsQuery,
                    queryAnalysis: queryAnalysis,
                    timestamp: Date.now()
                });
                
                // Save chat state
                saveChatState();
                
                if (type === 'user') {
                    chatBox.innerHTML = `
                        <div class="chat-section">
                            <div class="author">
                                <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMjAiIGN5PSIyMCIgcj0iMjAiIGZpbGw9IiMwYTU3ZDQiLz4KPHN2ZyB4PSIxMiIgeT0iMTIiIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgdmlld0JveD0iMCAwIDE2IDE2IiBmaWxsPSJub25lIj4KPHBhdGggZD0iTTggMTJDMTAuMjA5MSAxMiAxMiAxMC4yMDkxIDEyIDhDMTIgNS43OTA5IDEwLjIwOTEgNCA4IDRDNS43OTA5IDQgNCA1Ljc5MDkgNCA4QzQgMTAuMjA5MSA1Ljc5MDkgMTIgOCAxMloiIGZpbGw9IndoaXRlIi8+CjxwYXRoIGQ9Ik04IDE0QzExLjMxMzcgMTQgMTQgMTEuMzEzNyAxNCA4QzE0IDQuNjg2MjkgMTEuMzEzNyAyIDggMkM0LjY4NjI5IDIgMiA0LjY4NjI5IDIgOEMyIDExLjMxMzcgNC42ODYyOSAxNCA4IDE0WiIgZmlsbD0id2hpdGUiLz4KPC9zdmc+Cjwvc3ZnPgo=" alt="You">
                            </div>
                            <div class="chat-content">
                                <h6 class="title">You</h6>
                                <p>${message}</p>
                            </div>
                        </div>
                    `;
                } else {
                    // For bot messages, start with typing cursor
                    chatBox.innerHTML = `
                        <div class="chat-section">
                            <div class="author">
                                <img src="{{ asset('assets/images/team/avater.png') }}" alt="Mews" loading="lazy">
                            </div>
                            <div class="chat-content">
                                <h6 class="title">Mews <span style="background: var(--accent-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; padding: 4px 8px; border-radius: 10px; font-size: 12px;">AI</span></h6>
                                <p><span class="typing-cursor">|</span></p>
                            </div>
                        </div>
                    `;
                    
                    // Start typing effect
                    typeMessage(chatBox, message, newsData, isNewsQuery, queryAnalysis);
                }
                
                chatContainer.appendChild(chatBox);
                // Don't auto-scroll when adding chat messages - let the typing function handle it
                feather.replace(); // Re-initialize feather icons for new content
            }
            
            // Ad frequency checking function
            function shouldShowAd() {
                messageCount++;
                
                switch(adFrequency) {
                    case 'disabled':
                        return false;
                    case 'every':
                        return true;
                    case 'every_2':
                        return messageCount % 2 === 0;
                    case 'every_3':
                        return messageCount % 3 === 0;
                    case 'every_5':
                        return messageCount % 5 === 0;
                    case 'random':
                        return Math.random() < 0.3; // 30% chance
                    default:
                        return true;
                }
            }
            
            // Ad rotation system - fetch from database
            let ads = [];
            
            async function fetchAds() {
                try {
                    const response = await fetch('{{ route("api.ads.chatbot") }}');
                    const data = await response.json();
                    if (data.ad) {
                        ads = [data.ad];
                    }
                } catch (error) {
                    console.error('Failed to fetch ads:', error);
                    // Fallback to default ads
                    ads = [
                        {
                            label: 'Sponsored',
                            content: 'Discover the latest AI-powered news insights and stay ahead of the curve with our premium features.',
                            cta: 'Learn More',
                            url: '#'
                        }
                    ];
                }
            }
            
            function getRandomAd() {
                if (ads.length === 0) return null;
                return ads[Math.floor(Math.random() * ads.length)];
            }
            
            function showAd(container) {
                const ad = getRandomAd();
                if (!ad) return;

                let mediaHtml = '';
                if (ad.media_type === 'image' && ad.media_url) {
                    mediaHtml = `<img src="${ad.media_url}" alt="${ad.media_alt || ad.title}" style="width: 100%; max-height: 200px; object-fit: cover; border-radius: 8px; margin-bottom: 10px;">`;
                } else if (ad.media_type === 'video' && ad.media_url) {
                    mediaHtml = `
                        <div style="position: relative; width: 100%; max-height: 200px; border-radius: 8px; margin-bottom: 10px; overflow: hidden;">
                            <video autoplay muted loop playsinline style="width: 100%; height: 100%; object-fit: cover;">
                                <source src="${ad.media_url}" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                            <div style="position: absolute; top: 5px; right: 5px; background: rgba(0,0,0,0.7); color: white; padding: 2px 6px; border-radius: 3px; font-size: 10px;">
                                VIDEO
                            </div>
                        </div>
                    `;
                }

                const adHtml = `
                    <div class="ad-container" data-ad-id="${ad.id}" data-cta-url="${ad.cta_url}" style="cursor: pointer;">
                        <button class="ad-close" onclick="event.stopPropagation(); this.parentElement.remove()">×</button>
                        <div class="ad-label">${ad.label}</div>
                        ${mediaHtml}
                        <div class="ad-title">${ad.title}</div>
                        <div class="ad-content">${ad.content}</div>
                        <div class="ad-cta">${ad.cta_text}</div>
                    </div>
                `;
                container.innerHTML = adHtml;
                
                // Add click event listener to the ad container
                const adContainer = container.querySelector('.ad-container');
                adContainer.addEventListener('click', function(e) {
                    e.preventDefault();
                    const adId = this.getAttribute('data-ad-id');
                    const ctaUrl = this.getAttribute('data-cta-url');
                    handleAdClick(adId, ctaUrl);
                });
                
                // Auto-remove ad after display_duration (if specified and > 0)
                // If duration is 0, ad stays visible until AI responds (default behavior)
                if (ad.display_duration && ad.display_duration > 0) {
                    setTimeout(() => {
                        if (adContainer && adContainer.parentNode) {
                            adContainer.style.transition = 'opacity 0.5s ease-out';
                            adContainer.style.opacity = '0';
                            setTimeout(() => {
                                if (adContainer.parentNode) {
                                    adContainer.remove();
                                }
                            }, 500); // Wait for fade out animation
                        }
                    }, ad.display_duration);
                }
                // If display_duration is 0, ad will stay visible until AI response completes
            }
            
            function handleAdClick(adId, ctaUrl) {
                // Track the click first
                fetch(`{{ url('api/ads') }}/${adId}/click`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    // Open the URL in a new tab after tracking
                    if (ctaUrl && ctaUrl !== '#') {
                        window.open(ctaUrl, '_blank');
                    }
                })
                .catch(error => {
                    console.error('Failed to track ad click:', error);
                    // Still open the URL even if tracking fails
                    if (ctaUrl && ctaUrl !== '#') {
                        window.open(ctaUrl, '_blank');
                    }
                });
            }
            
            function trackAdClick(adId) {
                // Keep this function for backward compatibility
                handleAdClick(adId, '#');
            }
            
            function addLoadingMessage() {
                const loadingId = 'loading-' + Date.now();
                const loadingBox = document.createElement('div');
                loadingBox.className = 'chat-box';
                loadingBox.id = loadingId;
                loadingBox.innerHTML = `
                    <div class="chat-section">
                        <div class="author">
                            <img src="{{ asset('assets/images/team/avater.png') }}" alt="Mews" loading="lazy">
                        </div>
                        <div class="chat-content">
                            <div class="thinking-indicator">
                                <div class="thinking-dot"></div>
                                <div class="thinking-dot"></div>
                                <div class="thinking-dot"></div>
                            </div>
                        </div>
                    </div>
                `;
                
                chatContainer.appendChild(loadingBox);
                // Don't auto-scroll for loading messages
                
                // Show ad after a short delay (simulating AI thinking time) - only if frequency allows
                setTimeout(async () => {
                    const chatContent = loadingBox.querySelector('.chat-content');
                    if (shouldShowAd()) {
                        await fetchAds(); // Fetch ads from database
                        showAd(chatContent);
                    }
                }, 1500); // Show ad after 1.5 seconds
                
                return loadingId;
            }
            
            function removeLoadingMessage(loadingId) {
                const loadingBox = document.getElementById(loadingId);
                if (loadingBox) {
                    loadingBox.remove();
                }
            }
            
            function typeMessage(chatBox, message, newsData = null, isNewsQuery = false, queryAnalysis = null) {
                let index = 0;
                // Get typing speed from settings
                const typingSpeedSetting = '{{ $uiSettings["typing_speed"] ?? "medium" }}';
                let typingSpeed;
                switch(typingSpeedSetting) {
                    case 'slow': typingSpeed = 50; break;
                    case 'fast': typingSpeed = 15; break;
                    case 'instant': typingSpeed = 0; break;
                    case 'medium':
                    default: typingSpeed = 30; break;
                }
                const messageContent = chatBox.querySelector('.chat-content');
                
                function typeNextChar() {
                    if (index < message.length) {
                        // Show the current text with cursor
                        const currentText = message.substring(0, index + 1);
                        messageContent.innerHTML = `
                            <h6 class="title">Mews <span style="background: var(--accent-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; padding: 4px 8px; border-radius: 10px; font-size: 12px;">AI</span></h6>
                            <p>${currentText}<span class="typing-cursor">|</span></p>
                        `;
                        index++;
                        
                        // Continue typing (skip animation if instant)
                        if (typingSpeed > 0) {
                            setTimeout(typeNextChar, typingSpeed);
                        } else {
                            // For instant, show all text immediately
                            index = message.length;
                            typeNextChar();
                        }
                    } else {
                        // Typing complete, show full message with news cards if available
                        let content = `<p>${message}</p>`;
                        
                        // Add news cards if available and this is a news query
                        if (newsData && newsData.length > 0 && isNewsQuery) {
                            content += '<div class="news-cards" id="news-cards-container">';
                            newsData.forEach((article, index) => {
                                console.log('Article data:', article); // Debug log
                                const imageUrl = article.image && article.image !== 'N/A' ? article.image : 'https://via.placeholder.com/300x180?text=No+Image';
                                const displayCategory = article.sub_category || article.category || 'General';
                                const cardId = index === 0 ? 'first-news-card' : '';
                                content += `
                                    <div class="news-card" id="${cardId}" onclick="openDeepDive(${article.id})" title="Click for Deep Dive analysis">
                                        <div class="news-card-image">
                                            <img src="${imageUrl}" alt="${article.title}" loading="lazy">
                                            <span class="news-card-category-overlay">${displayCategory}</span>
                                        </div>
                                        <div class="news-card-content-wrapper">
                                            <h6 class="news-title">${article.title}</h6>
                                            <div class="news-card-content">
                                                <p>${article.content}</p>
                                            </div>
                                            <div class="news-meta">
                                                <div class="news-meta-row">
                                                    <span class="news-date"><i data-feather="calendar" style="width:14px;height:14px;"></i> ${article.date}</span>
                                                    <span class="news-views"><i data-feather="eye" style="width:14px;height:14px;"></i> ${article.views}</span>
                                                </div>
                                                <div class="news-source">Deep Dive <i data-feather="arrow-right" style="width:14px;height:14px;"></i></div>
                                            </div>
                                        </div>
                                    </div>
                                `;
                            });
                            content += '</div>';
                            
                            // Add "more" suggestion for news queries
                            content += '<p style="color: var(--text-secondary); font-size: 0.9rem; margin-top: 15px; font-style: italic;">💡 <strong>Tip:</strong> Type "more" to get additional news on this topic!</p>';
                        }
                        
                        // Add query analysis process display
                        // Commented out to hide query analysis from user interface
                        /*
                        if (queryAnalysis) {
                            content += `
                                <div class="query-analysis" style="margin-top: 20px; padding: 15px; background: var(--bg-secondary); border-radius: 10px; border-left: 4px solid var(--accent-color);">
                                    <h6 style="color: var(--accent-color); margin: 0 0 10px 0; font-size: 14px; display: flex; align-items: center;">
                                        <i data-feather="search" style="width: 16px; height: 16px; margin-right: 8px;"></i>
                                        Query Analysis Process
                                    </h6>
                                    <div style="font-size: 12px; color: var(--text-secondary); line-height: 1.4;">
                                        <div style="margin-bottom: 8px;">
                                            <strong>Intent:</strong> <span style="color: var(--accent-color);">${queryAnalysis.intent_type || 'Unknown'}</span>
                                        </div>
                                        <div style="margin-bottom: 8px;">
                                            <strong>Keywords:</strong> <span style="color: var(--text-primary);">${queryAnalysis.keywords || 'None'}</span>
                                        </div>
                                        <div style="margin-bottom: 8px;">
                                            <strong>Category:</strong> <span style="color: var(--text-primary);">${queryAnalysis.category || 'General'}</span>
                                        </div>
                                        <div style="margin-bottom: 8px;">
                                            <strong>Timeframe:</strong> <span style="color: var(--text-primary);">${queryAnalysis.timeframe || 'Recent'}</span>
                                        </div>
                                        <div style="margin-top: 10px; padding-top: 10px; border-top: 1px solid var(--border-color);">
                                            <strong>Search Strategy:</strong> 
                                            <span style="color: var(--text-primary);">
                                                ${queryAnalysis.intent_type === 'news_query' ? 
                                                    'Title → Category search (strict matching)' : 
                                                    'General conversation handling'}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            `;
                        }
                        */
                        
                        messageContent.innerHTML = `
                            <h6 class="title">Mews <span style="background: var(--accent-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; padding: 4px 8px; border-radius: 10px; font-size: 12px;">AI</span></h6>
                            ${content}
                        `;
                        
                        // Re-initialize feather icons for news cards
                        feather.replace();
                        
                        // Scroll to first news card of this response if available, otherwise scroll to bottom
                        if (newsData && newsData.length > 0 && isNewsQuery) {
                            setTimeout(() => {
                                // Find the first news card within this specific chat box
                                const currentChatBox = chatBox;
                                const firstNewsCard = currentChatBox.querySelector('#first-news-card');
                                if (firstNewsCard) {
                                    firstNewsCard.scrollIntoView({ 
                                        behavior: 'smooth', 
                                        block: 'start',
                                        inline: 'nearest'
                                    });
                                } else {
                                    // Fallback to bottom scroll
                                    chatContainer.scrollTop = chatContainer.scrollHeight;
                                }
                            }, 100);
                        } else {
                            // No news cards, scroll to bottom
                            chatContainer.scrollTop = chatContainer.scrollHeight;
                        }
                    }
                    
                    // Auto-scroll during typing (only if no news cards)
                    if (!newsData || newsData.length === 0 || !isNewsQuery) {
                        chatContainer.scrollTop = chatContainer.scrollHeight;
                    }
                }
                
                // Start typing
                typeNextChar();
            }
        }
        
        // Function to open Deep Dive page
        function openDeepDive(articleId) {
            console.log('Opening Deep Dive for article ID:', articleId); // Debug log
            window.location.href = `{{ url('news/deep-dive') }}/${articleId}`;
        }

        // Function to open news articles (kept for backward compatibility)
        function openNewsArticle(url, title) {
            if (url && url !== '#' && url !== 'N/A') {
                window.open(url, '_blank');
            } else {
                // Fallback for invalid URLs
                alert(`Article: ${title}\n\nThis article doesn't have a valid source URL.`);
            }
        }
        
        // Handle mobile keyboard appearance
        let initialViewportHeight = window.innerHeight;
        window.addEventListener('resize', () => {
            if (window.innerHeight < initialViewportHeight) {
                // Keyboard is open, adjust layout if needed
                document.body.style.height = `${window.innerHeight}px`;
            } else {
                // Keyboard is closed, restore normal height
                document.body.style.height = 'auto';
            }
        });
        
        // Prevent zoom on double tap (iOS)
        let lastTouchEnd = 0;
        document.addEventListener('touchend', function (event) {
            const now = (new Date()).getTime();
            if (now - lastTouchEnd <= 300) {
                event.preventDefault();
            }
            lastTouchEnd = now;
        }, false);
        
    </script>
    {{-- FAB Chatbot - also on home page --}}
    @include('components.chat-fab')
</body>
</html>
