<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- PWA Meta Tags -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="Mews AI">
    <meta name="theme-color" content="#0a57d4">
    <meta name="msapplication-TileColor" content="#0a57d4">
    <meta name="msapplication-config" content="/browserconfig.xml">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="/manifest.json">
    
    <!-- OneSignal SDK -->
    <script src="https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js" defer></script>
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="{{ asset('assets/images/logo/apple-touch-icon-180x180.png') }}">
    <link rel="apple-touch-icon" sizes="152x152" href="{{ asset('assets/images/logo/apple-touch-icon-152x152.png') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/images/logo/apple-touch-icon-180x180.png') }}">
    <link rel="apple-touch-icon" sizes="167x167" href="{{ asset('assets/images/logo/apple-touch-icon-167x167.png') }}">
    
    <!-- Standard Icons -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('assets/images/logo/favicon.png') }}">

    <title>@yield('title', 'Mews AI News Chatbot')</title>

    <!-- Open Graph Meta Tags for Social Media Sharing -->
    <meta property="og:title" content="@yield('og_title', 'Mews AI - AI-Powered News Chatbot')">
    <meta property="og:description" content="@yield('og_description', 'Discover personalized news with Mews AI. Get intelligent insights, analysis, and stay informed with our AI-powered news chatbot.')">
    <meta property="og:image" content="{{ asset('assets/images/mews.png') }}">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="Mews AI - AI-Powered News Chatbot">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="Mews AI">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="@yield('og_title', 'Mews AI - AI-Powered News Chatbot')">
    <meta name="twitter:description" content="@yield('og_description', 'Discover personalized news with Mews AI. Get intelligent insights, analysis, and stay informed with our AI-powered news chatbot.')">
    <meta name="twitter:image" content="{{ asset('assets/images/mews.png') }}">
    <meta name="twitter:image:alt" content="Mews AI - AI-Powered News Chatbot">
    
    <!-- Additional Meta Tags -->
    <meta name="description" content="@yield('description', 'Discover personalized news with Mews AI. Get intelligent insights, analysis, and stay informed with our AI-powered news chatbot.')">
    <meta name="keywords" content="news, AI, chatbot, personalized news, Ghana news, AI analysis, news discovery">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --bg-primary: #ffffff;
            --bg-secondary: #f8f9fa;
            --text-primary: #333333;
            --text-secondary: #666666;
            --accent-color: #0a57d4;
            --accent-gradient: linear-gradient(135deg, #0a57d4 0%, #2d72f0 100%);
            --accent-hover: linear-gradient(135deg, #083a8f 0%, #1e4a9a 100%);
            --border-color: #dee2e6;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.1);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.2);
        }
        
        [data-theme="dark"] {
            --bg-primary: #1a1a1a;
            --bg-secondary: #2d2d2d;
            --text-primary: #ffffff;
            --text-secondary: #b3b3b3;
            --border-color: #404040;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.15);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.25);
        }
        
        /* PWA Loading Animation */
        .pwa-loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: var(--bg-primary);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }
        
        .pwa-loader.show {
            opacity: 1;
            visibility: visible;
        }
        
        .pwa-loader-content {
            text-align: center;
            color: var(--text-primary);
        }
        
        .pwa-spinner {
            width: 60px;
            height: 60px;
            border: 3px solid rgba(255, 107, 53, 0.2);
            border-top: 3px solid var(--accent-color);
            border-radius: 50%;
            animation: pwa-spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        
        @keyframes pwa-spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .pwa-loader-text {
            font-size: 16px;
            font-weight: 500;
            margin-bottom: 10px;
        }
        
        .pwa-loader-subtext {
            font-size: 14px;
            color: var(--text-secondary);
        }
        
        /* Pulsing dots animation */
        .pwa-dots {
            display: inline-block;
            margin-left: 5px;
        }
        
        .pwa-dots span {
            display: inline-block;
            width: 4px;
            height: 4px;
            border-radius: 50%;
            background: var(--accent-color);
            margin: 0 2px;
            animation: pwa-pulse 1.4s infinite ease-in-out both;
        }
        
        .pwa-dots span:nth-child(1) { animation-delay: -0.32s; }
        .pwa-dots span:nth-child(2) { animation-delay: -0.16s; }
        .pwa-dots span:nth-child(3) { animation-delay: 0s; }
        
        @keyframes pwa-pulse {
            0%, 80%, 100% {
                transform: scale(0);
                opacity: 0.5;
            }
            40% {
                transform: scale(1);
                opacity: 1;
            }
        }
        
        * {
            box-sizing: border-box;
        }
        
        body {
            background-color: var(--bg-primary);
            color: var(--text-primary);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            transition: all 0.3s ease;
            overflow-x: hidden;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        
        /* Mobile-First Navigation */
        .navbar {
            background: var(--bg-secondary) !important;
            border-bottom: 1px solid var(--border-color);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            position: sticky;
            top: 0;
            z-index: 1000;
            padding: 0.75rem 1rem;
        }
        
        .navbar-brand {
            font-weight: 700;
            font-size: 1.25rem;
            background: var(--accent-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .navbar-toggler {
            border: none;
            color: var(--text-primary);
        }
        
        .navbar-toggler:focus {
            box-shadow: none;
        }
        
        .nav-link {
            color: var(--text-primary) !important;
            font-weight: 500;
            padding: 0.5rem 1rem !important;
            border-radius: 8px;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover {
            background: var(--accent-gradient);
            color: white !important;
            transform: translateY(-1px);
        }
        
        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--accent-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 16px;
            font-weight: 600;
            border: 2px solid var(--border-color);
        }
        
        .dropdown-menu {
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        .dropdown-item {
            color: var(--text-primary);
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }
        
        .dropdown-item:hover {
            background: var(--accent-gradient);
            color: white;
        }
        
        .dropdown-divider {
            border-color: var(--border-color);
        }
        
        /* Theme Toggle Button */
        .theme-toggle {
            background: none !important;
            border: none !important;
            color: var(--text-primary) !important;
            font-weight: 500;
            padding: 0.5rem 1rem !important;
            border-radius: 8px;
            transition: all 0.3s ease;
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }
        
        .theme-toggle:hover {
            background: var(--accent-gradient) !important;
            color: white !important;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(255, 107, 53, 0.3);
        }
        
        .theme-toggle:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.2);
        }
        
        .theme-toggle i {
            transition: all 0.3s ease;
        }
        
        .theme-toggle:hover i {
            transform: scale(1.1);
        }
        
        /* Special styling for guest theme toggle */
        .navbar-nav .nav-item:first-child .theme-toggle {
            background: rgba(255, 107, 53, 0.1) !important;
            border: 1px solid rgba(255, 107, 53, 0.2) !important;
        }
        
        .navbar-nav .nav-item:first-child .theme-toggle:hover {
            background: var(--accent-gradient) !important;
            border-color: transparent !important;
        }
        
        /* Mobile Optimizations */
        @media (max-width: 768px) {
            .navbar {
                padding: 0.5rem 1rem;
            }
            
            .navbar-brand {
                font-size: 1.1rem;
            }
            
            .user-avatar {
                width: 32px;
                height: 32px;
                font-size: 14px;
            }
            
            .nav-link {
                padding: 0.75rem 1rem !important;
                text-align: center;
            }
        }
        
        /* App-like feel */
        .app-container {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .app-content {
            flex: 1;
            padding: 0;
        }
        
        /* Smooth transitions */
        .btn {
            transition: all 0.3s ease;
            border-radius: 8px;
            font-weight: 500;
        }
        
        .btn:hover {
            transform: translateY(-1px);
        }
        
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--bg-secondary);
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--accent-color);
            border-radius: 3px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #1e4a9a;
        }
    </style>
    @stack('styles')
    @yield('styles')
</head>
<body class="app-container">
    <!-- PWA Loading Animation -->
    <div class="pwa-loader" id="pwaLoader">
        <div class="pwa-loader-content">
            <div class="pwa-spinner"></div>
            <div class="pwa-loader-text">Loading<span class="pwa-dots"><span></span><span></span><span></span></span></div>
            <div class="pwa-loader-subtext">Please wait while we prepare your experience</div>
        </div>
    </div>

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg">
        <div class="container-fluid">
            <a class="navbar-brand" href="{{ route('home') }}">
                <i class="fas fa-newspaper"></i> Mews AI
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <i class="fas fa-bars"></i>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <!-- Theme Toggle for Non-Logged-In Users -->
                    @guest
                        <li class="nav-item">
                            <button class="nav-link theme-toggle" id="themeToggle" title="Toggle Theme">
                                <i class="fas fa-moon" id="themeIcon"></i>
                                <span class="d-none d-md-inline">Theme</span>
                            </button>
                        </li>
                    @endguest
                    
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('home') }}">
                            <i class="fas fa-home"></i> 
                            <span class="d-none d-md-inline">Home</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('elections.dashboard') }}" style="background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%); color: white !important; border-radius: 20px; padding: 6px 14px !important; margin: 0 8px;">
                            <i class="fas fa-vote-yea"></i> 
                            <span class="d-none d-md-inline">Elections</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('pwa.install') }}">
                            <i class="fas fa-download"></i> 
                            <span class="d-none d-md-inline">Install App</span>
                        </a>
                    </li>
                    @auth
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('user.dashboard') }}">
                                <i class="fas fa-tachometer-alt"></i> 
                                <span class="d-none d-md-inline">Dashboard</span>
                            </a>
                        </li>
                    @endauth
                </ul>
                
                <ul class="navbar-nav">
                    
                    @auth
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                                <div class="user-avatar me-2">
                                    {{ substr(auth()->user()->name, 0, 1) }}
                                </div>
                                <span class="d-none d-md-inline">{{ auth()->user()->name }}</span>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="{{ route('user.dashboard') }}">
                                    <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                                </a></li>
                                <li><a class="dropdown-item" href="{{ route('user.profile.edit') }}">
                                    <i class="fas fa-user me-2"></i> Profile
                                </a></li>
                                <li><a class="dropdown-item" href="{{ route('user.preferences.edit') }}">
                                    <i class="fas fa-cog me-2"></i> Preferences
                                </a></li>
                                <li><a class="dropdown-item" href="{{ route('user.bookmarks') }}">
                                    <i class="fas fa-bookmark me-2"></i> Bookmarks
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form method="POST" action="{{ route('logout') }}" class="d-inline">
                                        @csrf
                                        <button type="submit" class="dropdown-item">
                                            <i class="fas fa-sign-out-alt me-2"></i> Logout
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    @else
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">
                                <i class="fas fa-sign-in-alt"></i> 
                                <span class="d-none d-md-inline">Sign In</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">
                                <i class="fas fa-user-plus"></i> 
                                <span class="d-none d-md-inline">Sign Up</span>
                            </a>
                        </li>
                    @endauth
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="app-content">
        @yield('content')
    </main>

    {{-- FAB Chatbot - Persistent on all pages --}}
    @include('components.chat-fab')

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Theme Manager -->
    <script src="{{ asset('js/theme-manager.js') }}"></script>
    
    <!-- Theme Toggle Script -->
    <script>
    // OneSignal Initialization
    window.OneSignal = window.OneSignal || [];
    OneSignal.push(function() {
        OneSignal.init({
            appId: "{{ config('services.onesignal.app_id') }}",
            safari_web_id: "{{ config('services.onesignal.safari_web_id') }}",
            notifyButton: {
                enable: false, // We'll handle this manually
            },
            allowLocalhostAsSecureOrigin: true,
            // Production domain configuration
            subdomainName: "mewsai",
        });
            
            // Get the user's OneSignal ID
            OneSignal.getUserId().then(function(userId) {
                if (userId) {
                    // Store the player ID for later use
                    localStorage.setItem('onesignal_player_id', userId);
                    
                    // Send player ID to server if user is logged in
                    @auth
                    fetch('/api/onesignal/subscribe', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({
                            player_id: userId,
                            device_type: 'web',
                            browser: navigator.userAgent,
                            timezone: Intl.DateTimeFormat().resolvedOptions().timeZone
                        })
                    });
                    @endauth
                }
            });
            
            // Handle notification permission
            OneSignal.getNotificationPermission().then(function(permission) {
                if (permission === 'granted') {
                    console.log('Notification permission granted');
                } else if (permission === 'denied') {
                    console.log('Notification permission denied');
                } else {
                    console.log('Notification permission not determined');
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            // Theme management is now handled by the centralized ThemeManager
            // Just ensure theme toggle buttons have the correct data attributes
            const themeToggle = document.getElementById('themeToggle');
            if (themeToggle) {
                themeToggle.setAttribute('data-theme-toggle', 'true');
                const themeIcon = themeToggle.querySelector('i');
                if (themeIcon) {
                    themeIcon.setAttribute('data-theme-icon', 'true');
                }
            }
        });
        
        // PWA Service Worker Registration
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('/sw.js')
                    .then(function(registration) {
                        console.log('Service Worker registered successfully:', registration.scope);
                        
                        // Check for updates
                        registration.addEventListener('updatefound', function() {
                            const newWorker = registration.installing;
                            newWorker.addEventListener('statechange', function() {
                                if (newWorker.state === 'installed' && navigator.serviceWorker.controller) {
                                    // New content is available, show update notification
                                    showUpdateNotification();
                                }
                            });
                        });
                    })
                    .catch(function(error) {
                        console.log('Service Worker registration failed:', error);
                    });
            });
        }
        
        // PWA Install Prompt
        let deferredPrompt;
        window.addEventListener('beforeinstallprompt', function(e) {
            console.log('PWA install prompt triggered');
            e.preventDefault();
            deferredPrompt = e;
            showInstallPrompt();
        });
        
        // PWA Installed
        window.addEventListener('appinstalled', function(e) {
            console.log('PWA was installed');
            hideInstallPrompt();
        });
        
        function showUpdateNotification() {
            if ('Notification' in window && Notification.permission === 'granted') {
                new Notification('Mews AI Update Available', {
                    body: 'A new version is available. Refresh to update.',
                    icon: '/assets/images/icon-192x192.png',
                    tag: 'update-available'
                });
            }
        }
        
        function showInstallPrompt() {
            // Create install button if it doesn't exist
            if (!document.getElementById('pwa-install-btn')) {
                const installBtn = document.createElement('button');
                installBtn.id = 'pwa-install-btn';
                installBtn.innerHTML = '<i class="fas fa-download"></i> Install App';
                installBtn.className = 'btn btn-primary position-fixed';
                installBtn.style.cssText = `
                    bottom: 20px;
                    right: 20px;
                    z-index: 9999;
                    border-radius: 25px;
                    padding: 0.75rem 1.5rem;
                    box-shadow: 0 4px 20px rgba(255, 107, 53, 0.3);
                    animation: slideInUp 0.3s ease;
                `;
                
                installBtn.addEventListener('click', function() {
                    if (deferredPrompt) {
                        deferredPrompt.prompt();
                        deferredPrompt.userChoice.then(function(choiceResult) {
                            if (choiceResult.outcome === 'accepted') {
                                console.log('User accepted the install prompt');
                            } else {
                                console.log('User dismissed the install prompt');
                            }
                            deferredPrompt = null;
                            hideInstallPrompt();
                        });
                    }
                });
                
                document.body.appendChild(installBtn);
                
                // Auto-hide after 10 seconds
                setTimeout(hideInstallPrompt, 10000);
            }
        }
        
        function hideInstallPrompt() {
            const installBtn = document.getElementById('pwa-install-btn');
            if (installBtn) {
                installBtn.style.animation = 'slideOutDown 0.3s ease';
                setTimeout(() => {
                    installBtn.remove();
                }, 300);
            }
        }
        
        // Add CSS animations
        const style = document.createElement('style');
        style.textContent = `
            @keyframes slideInUp {
                from { transform: translateY(100px); opacity: 0; }
                to { transform: translateY(0); opacity: 1; }
            }
            @keyframes slideOutDown {
                from { transform: translateY(0); opacity: 1; }
                to { transform: translateY(100px); opacity: 0; }
            }
        `;
        document.head.appendChild(style);
        
        // PWA Loading Animation Functions
        function showPWALoader(message = 'Loading') {
            const loader = document.getElementById('pwaLoader');
            const loaderText = loader.querySelector('.pwa-loader-text');
            if (loaderText) {
                loaderText.innerHTML = message + '<span class="pwa-dots"><span></span><span></span><span></span></span>';
            }
            loader.classList.add('show');
        }
        
        function hidePWALoader() {
            const loader = document.getElementById('pwaLoader');
            loader.classList.remove('show');
        }
        
        // Show loader on page navigation
        document.addEventListener('DOMContentLoaded', function() {
            // Hide loader after page loads
            setTimeout(hidePWALoader, 500);
            
            // Show loader on link clicks
            document.addEventListener('click', function(e) {
                const link = e.target.closest('a');
                if (link && link.href && !link.href.startsWith('#') && !link.href.startsWith('javascript:')) {
                    // Check if it's an external link or different page
                    const currentDomain = window.location.origin;
                    const linkDomain = new URL(link.href).origin;
                    
                    if (linkDomain === currentDomain) {
                        showPWALoader('Navigating');
                    }
                }
            });
            
            // Show loader on form submissions
            document.addEventListener('submit', function(e) {
                showPWALoader('Processing');
            });
        });
        
        // Make functions globally available
        window.showPWALoader = showPWALoader;
        window.hidePWALoader = hidePWALoader;
    </script>
</body>
</html>
