@extends('layouts.app')

@section('title', 'Compare Elections - Election Intelligence')

@section('styles')
<style>
    .compare-page {
        min-height: 100vh;
        background: var(--bg-secondary);
        padding-bottom: 40px;
    }

    .compare-header {
        background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
        padding: 20px 16px;
        color: white;
    }

    .compare-header-content {
        max-width: 1200px;
        margin: 0 auto;
    }

    .compare-title {
        font-size: 1.5rem;
        font-weight: 700;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .compare-content {
        max-width: 1200px;
        margin: 0 auto;
        padding: 16px;
    }

    .compare-selectors {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
        margin-bottom: 24px;
    }

    .compare-selector {
        display: flex;
        align-items: center;
        gap: 8px;
        background: var(--bg-primary);
        padding: 8px 12px;
        border-radius: 8px;
    }

    .compare-selector label {
        font-size: 0.85rem;
        font-weight: 500;
        white-space: nowrap;
    }

    .compare-selector select {
        border: 1px solid var(--border-color);
        border-radius: 6px;
        padding: 6px 10px;
        font-size: 0.9rem;
        background: var(--bg-primary);
        color: var(--text-primary);
    }

    .comparison-table {
        background: var(--bg-primary);
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }

    .comparison-table table {
        width: 100%;
        border-collapse: collapse;
    }

    .comparison-table th,
    .comparison-table td {
        padding: 12px 16px;
        text-align: center;
        border-bottom: 1px solid var(--border-color);
    }

    .comparison-table th {
        background: var(--bg-secondary);
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .comparison-table .region-cell {
        text-align: left;
        font-weight: 500;
    }

    .comparison-table .npp { color: #0057B7; }
    .comparison-table .ndc { color: #009739; }

    .swing-positive {
        color: #22c55e;
    }

    .swing-negative {
        color: #ef4444;
    }

    .winner-cell {
        font-weight: 600;
    }

    .winner-cell.npp {
        background: rgba(0, 87, 183, 0.1);
    }

    .winner-cell.ndc {
        background: rgba(0, 151, 57, 0.1);
    }

    .swing-indicator {
        font-size: 0.75rem;
        padding: 2px 6px;
        border-radius: 4px;
    }

    .swing-indicator.gained {
        background: rgba(34, 197, 94, 0.1);
        color: #22c55e;
    }

    .swing-indicator.lost {
        background: rgba(239, 68, 68, 0.1);
        color: #ef4444;
    }

    .swing-indicator.held {
        background: rgba(107, 114, 128, 0.1);
        color: #6b7280;
    }

    .summary-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 16px;
        margin-bottom: 24px;
    }

    .summary-card {
        background: var(--bg-primary);
        border-radius: 12px;
        padding: 20px;
        text-align: center;
    }

    .summary-card-value {
        font-size: 2rem;
        font-weight: 700;
    }

    .summary-card-value.npp { color: #0057B7; }
    .summary-card-value.ndc { color: #009739; }

    .summary-card-label {
        font-size: 0.85rem;
        color: var(--text-secondary);
        margin-top: 4px;
    }

    /* Mobile responsive table */
    @media (max-width: 768px) {
        .comparison-table {
            overflow-x: auto;
        }
        
        .comparison-table table {
            min-width: 600px;
        }
    }
</style>
@endsection

@section('content')
<div class="compare-page">
    <div class="compare-header">
        <div class="compare-header-content">
            <a href="{{ route('elections.dashboard') }}" class="text-white text-decoration-none mb-2 d-inline-block" style="font-size: 0.85rem;">
                ← Back to Dashboard
            </a>
            <div class="compare-title">
                <span>📈</span>
                Compare Elections
            </div>
            <p class="mb-0 mt-2" style="font-size: 0.9rem; opacity: 0.8;">
                See how voting patterns changed across elections
            </p>
        </div>
    </div>

    <div class="compare-content">
        <!-- Year Selectors -->
        <form method="GET" class="compare-selectors">
            <div class="compare-selector">
                <label>From:</label>
                <select name="year2" onchange="this.form.submit()">
                    @foreach($availableYears as $year)
                        <option value="{{ $year }}" {{ $year2 == $year ? 'selected' : '' }}>{{ $year }}</option>
                    @endforeach
                </select>
            </div>
            
            <div class="compare-selector">
                <label>To:</label>
                <select name="year1" onchange="this.form.submit()">
                    @foreach($availableYears as $year)
                        <option value="{{ $year }}" {{ $year1 == $year ? 'selected' : '' }}>{{ $year }}</option>
                    @endforeach
                </select>
            </div>
            
            <div class="compare-selector">
                <label>Type:</label>
                <select name="type" onchange="this.form.submit()">
                    <option value="presidential" {{ $type === 'presidential' ? 'selected' : '' }}>Presidential</option>
                    <option value="parliamentary" {{ $type === 'parliamentary' ? 'selected' : '' }}>Parliamentary</option>
                </select>
            </div>
        </form>

        @if($election1 && $election2)
        <!-- Summary Cards -->
        <div class="summary-cards">
            @php
                $nppGains = collect($comparison)->filter(fn($c) => $c['year1']['winner'] === 'NPP' && $c['year2']['winner'] === 'NDC')->count();
                $ndcGains = collect($comparison)->filter(fn($c) => $c['year1']['winner'] === 'NDC' && $c['year2']['winner'] === 'NPP')->count();
                $nppHolds = collect($comparison)->filter(fn($c) => $c['year1']['winner'] === 'NPP' && $c['year2']['winner'] === 'NPP')->count();
                $ndcHolds = collect($comparison)->filter(fn($c) => $c['year1']['winner'] === 'NDC' && $c['year2']['winner'] === 'NDC')->count();
            @endphp
            
            <div class="summary-card">
                <div class="summary-card-value npp">{{ $nppGains }}</div>
                <div class="summary-card-label">NPP Gains (from NDC)</div>
            </div>
            
            <div class="summary-card">
                <div class="summary-card-value ndc">{{ $ndcGains }}</div>
                <div class="summary-card-label">NDC Gains (from NPP)</div>
            </div>
            
            <div class="summary-card">
                <div class="summary-card-value npp">{{ $nppHolds }}</div>
                <div class="summary-card-label">NPP Holds</div>
            </div>
            
            <div class="summary-card">
                <div class="summary-card-value ndc">{{ $ndcHolds }}</div>
                <div class="summary-card-label">NDC Holds</div>
            </div>
        </div>

        <!-- Comparison Table -->
        <div class="comparison-table">
            <table>
                <thead>
                    <tr>
                        <th class="region-cell">Region</th>
                        <th colspan="2">{{ $year2 }}</th>
                        <th colspan="2">{{ $year1 }}</th>
                        <th colspan="2">Swing</th>
                        <th>Change</th>
                    </tr>
                    <tr>
                        <th></th>
                        <th class="npp">NPP</th>
                        <th class="ndc">NDC</th>
                        <th class="npp">NPP</th>
                        <th class="ndc">NDC</th>
                        <th class="npp">NPP</th>
                        <th class="ndc">NDC</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($comparison as $row)
                    <tr>
                        <td class="region-cell">{{ $row['region'] }}</td>
                        <td class="npp {{ $row['year2']['winner'] === 'NPP' ? 'winner-cell npp' : '' }}">
                            {{ number_format($row['year2']['npp'], 1) }}%
                        </td>
                        <td class="ndc {{ $row['year2']['winner'] === 'NDC' ? 'winner-cell ndc' : '' }}">
                            {{ number_format($row['year2']['ndc'], 1) }}%
                        </td>
                        <td class="npp {{ $row['year1']['winner'] === 'NPP' ? 'winner-cell npp' : '' }}">
                            {{ number_format($row['year1']['npp'], 1) }}%
                        </td>
                        <td class="ndc {{ $row['year1']['winner'] === 'NDC' ? 'winner-cell ndc' : '' }}">
                            {{ number_format($row['year1']['ndc'], 1) }}%
                        </td>
                        <td class="{{ $row['swing']['npp'] > 0 ? 'swing-positive' : ($row['swing']['npp'] < 0 ? 'swing-negative' : '') }}">
                            {{ $row['swing']['npp'] > 0 ? '+' : '' }}{{ number_format($row['swing']['npp'], 1) }}
                        </td>
                        <td class="{{ $row['swing']['ndc'] > 0 ? 'swing-positive' : ($row['swing']['ndc'] < 0 ? 'swing-negative' : '') }}">
                            {{ $row['swing']['ndc'] > 0 ? '+' : '' }}{{ number_format($row['swing']['ndc'], 1) }}
                        </td>
                        <td>
                            @if($row['year1']['winner'] !== $row['year2']['winner'])
                                <span class="swing-indicator {{ $row['year1']['winner'] === 'NPP' ? 'gained' : 'lost' }}">
                                    {{ $row['year1']['winner'] }} Gain
                                </span>
                            @else
                                <span class="swing-indicator held">
                                    {{ $row['year1']['winner'] }} Hold
                                </span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-4 p-3 bg-light rounded" style="font-size: 0.85rem;">
            <strong>Reading the table:</strong>
            <ul class="mb-0 mt-2">
                <li>Highlighted cells show the winning party in each region</li>
                <li>Swing shows the change in vote share from {{ $year2 }} to {{ $year1 }}</li>
                <li><span class="text-success">Green</span> numbers indicate gains, <span class="text-danger">red</span> indicate losses</li>
            </ul>
        </div>
        @else
        <div class="text-center py-5">
            <p class="text-muted">Select two election years to compare</p>
        </div>
        @endif
    </div>
</div>
@endsection
