<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - Mews AI</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #0a57d4;
            --secondary-color: #2d72f0;
            --accent-color: #5a95ff;
            --bg-primary: #1a1a1a;
            --bg-secondary: #2d2d2d;
            --text-primary: #ffffff;
            --text-secondary: #b3b3b3;
            --border-color: #404040;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.15);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.25);
        }
        
        [data-theme="light"] {
            --bg-primary: #ffffff;
            --bg-secondary: #f8f9fa;
            --text-primary: #333333;
            --text-secondary: #666666;
            --border-color: #dee2e6;
            --card-shadow: 0 8px 32px rgba(255, 107, 53, 0.1);
            --card-shadow-hover: 0 12px 40px rgba(255, 107, 53, 0.2);
        }

        body {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px 0;
            color: var(--text-primary);
            transition: all 0.3s ease;
        }

        .register-container {
            background: var(--bg-primary);
            border: 1px solid var(--border-color);
            border-radius: 20px;
            box-shadow: var(--card-shadow);
            padding: 40px;
            width: 100%;
            max-width: 500px;
            transition: all 0.3s ease;
        }

        .register-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .register-header h1 {
            color: var(--primary-color);
            font-weight: bold;
            margin-bottom: 10px;
        }

        .register-header p {
            color: var(--text-secondary);
            margin: 0;
        }

        .form-control {
            background: var(--bg-secondary);
            border: 2px solid var(--border-color);
            border-radius: 10px;
            padding: 12px 15px;
            color: var(--text-primary);
            transition: all 0.3s ease;
        }

        .form-control:focus {
            background: var(--bg-secondary);
            border-color: var(--primary-color);
            color: var(--text-primary);
            box-shadow: 0 0 0 0.2rem rgba(255, 107, 53, 0.25);
        }
        
        .form-control::placeholder {
            color: var(--text-secondary);
        }

        .form-label {
            color: var(--text-primary);
            font-weight: 600;
            margin-bottom: 8px;
            display: block;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border: none;
            border-radius: 10px;
            padding: 12px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(255, 107, 53, 0.4);
        }

        .login-link {
            text-align: center;
            margin-top: 20px;
        }

        .login-link a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 600;
        }

        .login-link a:hover {
            text-decoration: underline;
        }
        
        /* Loading Indicators */
        .loading-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
            margin-right: 8px;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .btn-loading {
            opacity: 0.7;
            pointer-events: none;
            position: relative;
        }
        
        .btn-loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 16px;
            height: 16px;
            margin: -8px 0 0 -8px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }
        
        .btn-loading .btn-text {
            opacity: 0;
        }
        
        /* Subtle loading overlay */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(2px);
            z-index: 9999;
            display: none;
            align-items: center;
            justify-content: center;
        }
        
        .loading-overlay.show {
            display: flex;
        }
        
        .loading-content {
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            box-shadow: var(--card-shadow);
        }
        
        .loading-content .loading-spinner {
            width: 24px;
            height: 24px;
            margin: 0 0 12px 0;
        }
        
        .loading-content .loading-text {
            color: var(--text-primary);
            font-size: 14px;
            font-weight: 500;
        }

        .back-to-home {
            position: absolute;
            top: 20px;
            left: 20px;
            color: white;
            text-decoration: none;
            font-weight: 600;
        }

        .back-to-home:hover {
            color: white;
            text-decoration: underline;
        }

        .form-check-input:checked {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .interests-section {
            margin-top: 20px;
        }

        .interest-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            margin-top: 10px;
        }

        .interest-tag {
            background: #f8f9fa;
            border: 2px solid #e9ecef;
            border-radius: 20px;
            padding: 5px 15px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 14px;
            color: #333333;
        }

        .interest-tag:hover {
            border-color: var(--primary-color);
        }

        .interest-tag.selected {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }

        /* Dark mode styling for interest tags */
        [data-theme="dark"] .interest-tag {
            background: #2d2d2d;
            border-color: #404040;
            color: #ffffff;
        }

        [data-theme="dark"] .interest-tag:hover {
            border-color: var(--primary-color);
            background: #404040;
        }

        [data-theme="dark"] .interest-tag.selected {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }
    </style>
</head>
<body>
    <a href="{{ route('news.chatbot') }}" class="back-to-home">
        <i class="fas fa-arrow-left"></i> Back to Mews AI
    </a>

    <div class="register-container">
        <div class="register-header">
            <h1><i class="fas fa-user-plus"></i> Join Mews AI</h1>
            <p>Create your account to personalize your news experience</p>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('register') }}">
            @csrf
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="email" class="form-label">Email Address *</label>
                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                           id="email" name="email" value="{{ old('email') }}" required>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="password" class="form-label">Password *</label>
                    <input type="password" class="form-control @error('password') is-invalid @enderror" 
                           id="password" name="password" required>
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="first_name" class="form-label">First Name</label>
                    <input type="text" class="form-control" id="first_name" name="first_name" 
                           value="{{ old('first_name') }}">
                </div>

                <div class="col-md-6 mb-3">
                    <label for="last_name" class="form-label">Last Name</label>
                    <input type="text" class="form-control" id="last_name" name="last_name" 
                           value="{{ old('last_name') }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="password_confirmation" class="form-label">Confirm Password *</label>
                    <input type="password" class="form-control" id="password_confirmation" 
                           name="password_confirmation" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="phone" class="form-label">Phone Number</label>
                    <input type="tel" class="form-control" id="phone" name="phone" 
                           value="{{ old('phone') }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="location" class="form-label">Location (Ghana)</label>
                    <select class="form-control" id="location" name="location">
                        <option value="">Select your location</option>
                        <option value="Greater Accra" {{ old('location') == 'Greater Accra' ? 'selected' : '' }}>Greater Accra</option>
                        <option value="Ashanti" {{ old('location') == 'Ashanti' ? 'selected' : '' }}>Ashanti</option>
                        <option value="Western" {{ old('location') == 'Western' ? 'selected' : '' }}>Western</option>
                        <option value="Eastern" {{ old('location') == 'Eastern' ? 'selected' : '' }}>Eastern</option>
                        <option value="Central" {{ old('location') == 'Central' ? 'selected' : '' }}>Central</option>
                        <option value="Volta" {{ old('location') == 'Volta' ? 'selected' : '' }}>Volta</option>
                        <option value="Northern" {{ old('location') == 'Northern' ? 'selected' : '' }}>Northern</option>
                        <option value="Upper East" {{ old('location') == 'Upper East' ? 'selected' : '' }}>Upper East</option>
                        <option value="Upper West" {{ old('location') == 'Upper West' ? 'selected' : '' }}>Upper West</option>
                        <option value="Brong-Ahafo" {{ old('location') == 'Brong-Ahafo' ? 'selected' : '' }}>Brong-Ahafo</option>
                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="language_preference" class="form-label">Language Preference</label>
                    <select class="form-control" id="language_preference" name="language_preference">
                        <option value="en" {{ old('language_preference', 'en') == 'en' ? 'selected' : '' }}>English</option>
                        <option value="twi" {{ old('language_preference') == 'twi' ? 'selected' : '' }}>Twi</option>
                        <option value="ga" {{ old('language_preference') == 'ga' ? 'selected' : '' }}>Ga</option>
                        <option value="ewe" {{ old('language_preference') == 'ewe' ? 'selected' : '' }}>Ewe</option>
                    </select>
                </div>
            </div>


            <div class="interests-section">
                <label class="form-label">News Interests (Select all that apply)</label>
                <div class="interest-tags">
                    @php
                        // Use actual subcategories from the database
                        $interests = ['Politics', 'Sports', 'Business', 'Technology', 'Entertainment', 'International', 'Local', 'General'];
                        $oldInterests = old('interests', []);
                        // old('interests') returns JSON string when form resubmits; ensure array
                        if (is_string($oldInterests)) {
                            $decoded = json_decode($oldInterests, true);
                            $oldInterests = is_array($decoded) ? $decoded : [];
                        }
                    @endphp
                    
                    @foreach($interests as $interest)
                        <div class="interest-tag {{ in_array($interest, $oldInterests) ? 'selected' : '' }}" 
                             data-interest="{{ $interest }}">
                            {{ $interest }}
                        </div>
                    @endforeach
                </div>
                <input type="hidden" name="interests" id="interests" value="{{ json_encode($oldInterests) }}">
            </div>

            <button type="submit" class="btn btn-primary w-100 mt-4" id="registerBtn">
                <span class="btn-text">
                    <i class="fas fa-user-plus"></i> Create Account
                </span>
            </button>
        </form>

        <div class="login-link">
            <p>Already have an account? <a href="{{ route('login') }}">Sign in here</a></p>
        </div>
    </div>

    <!-- Loading Overlay -->
    <div id="loadingOverlay" class="loading-overlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <div class="loading-text" id="loadingText">Loading...</div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Handle interest selection
        document.querySelectorAll('.interest-tag').forEach(tag => {
            tag.addEventListener('click', function() {
                this.classList.toggle('selected');
                updateInterests();
            });
        });

        function updateInterests() {
            const selected = document.querySelectorAll('.interest-tag.selected');
            const interests = Array.from(selected).map(tag => tag.dataset.interest);
            document.getElementById('interests').value = JSON.stringify(interests);
        }
        
        // Loading indicator functions
        function showLoading(message = 'Loading...') {
            const overlay = document.getElementById('loadingOverlay');
            const text = document.getElementById('loadingText');
            text.textContent = message;
            overlay.classList.add('show');
        }
        
        function hideLoading() {
            const overlay = document.getElementById('loadingOverlay');
            overlay.classList.remove('show');
        }
        
        function setButtonLoading(button, loading = true) {
            if (loading) {
                button.classList.add('btn-loading');
                button.disabled = true;
                const text = button.querySelector('.btn-text');
                if (text) {
                    text.style.opacity = '0';
                }
            } else {
                button.classList.remove('btn-loading');
                button.disabled = false;
                const text = button.querySelector('.btn-text');
                if (text) {
                    text.style.opacity = '1';
                }
            }
        }

        // Theme Management
        document.addEventListener('DOMContentLoaded', function() {
            // Theme management is now handled by the centralized ThemeManager
            // Just ensure the theme is applied to the body element
            const savedTheme = localStorage.getItem('theme');
            if (savedTheme === 'dark') {
                document.body.setAttribute('data-theme', 'dark');
            } else {
                // Default to light mode if no theme is saved
                document.body.removeAttribute('data-theme');
            }
            
            // Handle register form submission
            const registerForm = document.querySelector('form');
            const registerBtn = document.getElementById('registerBtn');
            
            if (registerForm && registerBtn) {
                registerForm.addEventListener('submit', function(e) {
                    // Show loading state
                    setButtonLoading(registerBtn, true);
                    showLoading('Creating account...');
                    
                    // The form will submit normally, but we show loading feedback
                });
            }
        });
    </script>
</body>
</html>
