@extends('admin.layout')

@section('title', 'Notification Subscriptions')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Notification Subscriptions</h1>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Campaigns
                </a>
            </div>

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_subscriptions']) }}</h4>
                                    <p class="card-text">Total Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-users fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['active_subscriptions']) }}</h4>
                                    <p class="card-text">Active Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-check-circle fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['web_subscriptions']) }}</h4>
                                    <p class="card-text">Web Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-desktop fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['mobile_subscriptions']) }}</h4>
                                    <p class="card-text">Mobile Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-mobile-alt fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">All Subscriptions</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Device</th>
                                    <th>Categories</th>
                                    <th>Preferences</th>
                                    <th>Status</th>
                                    <th>Last Activity</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($subscriptions as $subscription)
                                    <tr>
                                        <td>
                                            @if($subscription->user)
                                                <div>
                                                    <strong>{{ $subscription->user->name }}</strong>
                                                    <br>
                                                    <small class="text-muted">{{ $subscription->user->email }}</small>
                                                </div>
                                            @else
                                                <span class="text-muted">Guest User</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div>
                                                <span class="badge bg-info">{{ ucfirst($subscription->device_type ?? 'Unknown') }}</span>
                                                @if($subscription->browser)
                                                    <br>
                                                    <small class="text-muted">{{ $subscription->browser }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            @if($subscription->subscribed_categories)
                                                <div class="d-flex flex-wrap gap-1">
                                                    @foreach(array_slice($subscription->subscribed_categories, 0, 3) as $category)
                                                        <span class="badge bg-secondary">{{ ucfirst($category) }}</span>
                                                    @endforeach
                                                    @if(count($subscription->subscribed_categories) > 3)
                                                        <span class="badge bg-light text-dark">+{{ count($subscription->subscribed_categories) - 3 }}</span>
                                                    @endif
                                                </div>
                                            @else
                                                <span class="text-muted">All categories</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                @if($subscription->breaking_news_enabled)
                                                    <span class="badge bg-danger">Breaking</span>
                                                @endif
                                                @if($subscription->daily_digest_enabled)
                                                    <span class="badge bg-primary">Daily</span>
                                                @endif
                                                @if($subscription->weekly_summary_enabled)
                                                    <span class="badge bg-success">Weekly</span>
                                                @endif
                                                @if($subscription->marketing_enabled)
                                                    <span class="badge bg-warning">Marketing</span>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            @if($subscription->is_active)
                                                <span class="badge bg-success">Active</span>
                                            @else
                                                <span class="badge bg-secondary">Inactive</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($subscription->last_activity_at)
                                                {{ $subscription->last_activity_at->diffForHumans() }}
                                            @else
                                                <span class="text-muted">Never</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#subscriptionModal{{ $subscription->id }}">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                @if($subscription->is_active)
                                                    <form action="{{ route('admin.notifications.subscriptions') }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('PATCH')
                                                        <input type="hidden" name="subscription_id" value="{{ $subscription->id }}">
                                                        <input type="hidden" name="action" value="deactivate">
                                                        <button type="submit" class="btn btn-sm btn-outline-warning" onclick="return confirm('Are you sure you want to deactivate this subscription?')">
                                                            <i class="fas fa-pause"></i>
                                                        </button>
                                                    </form>
                                                @else
                                                    <form action="{{ route('admin.notifications.subscriptions') }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('PATCH')
                                                        <input type="hidden" name="subscription_id" value="{{ $subscription->id }}">
                                                        <input type="hidden" name="action" value="activate">
                                                        <button type="submit" class="btn btn-sm btn-outline-success" onclick="return confirm('Are you sure you want to activate this subscription?')">
                                                            <i class="fas fa-play"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>

                                    <!-- Subscription Details Modal -->
                                    <div class="modal fade" id="subscriptionModal{{ $subscription->id }}" tabindex="-1">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Subscription Details</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h6>User Information</h6>
                                                            @if($subscription->user)
                                                                <p><strong>Name:</strong> {{ $subscription->user->name }}</p>
                                                                <p><strong>Email:</strong> {{ $subscription->user->email }}</p>
                                                            @else
                                                                <p><strong>Type:</strong> Guest User</p>
                                                            @endif
                                                            <p><strong>Player ID:</strong> {{ $subscription->onesignal_player_id }}</p>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h6>Device Information</h6>
                                                            <p><strong>Device Type:</strong> {{ ucfirst($subscription->device_type ?? 'Unknown') }}</p>
                                                            <p><strong>Browser:</strong> {{ $subscription->browser ?? 'Unknown' }}</p>
                                                            <p><strong>OS:</strong> {{ $subscription->os ?? 'Unknown' }}</p>
                                                            <p><strong>Country:</strong> {{ $subscription->country ?? 'Unknown' }}</p>
                                                            <p><strong>Timezone:</strong> {{ $subscription->timezone ?? 'Unknown' }}</p>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h6>Subscribed Categories</h6>
                                                            @if($subscription->subscribed_categories)
                                                                <div class="d-flex flex-wrap gap-1">
                                                                    @foreach($subscription->subscribed_categories as $category)
                                                                        <span class="badge bg-secondary">{{ ucfirst($category) }}</span>
                                                                    @endforeach
                                                                </div>
                                                            @else
                                                                <p class="text-muted">All categories</p>
                                                            @endif
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h6>Notification Preferences</h6>
                                                            <div class="d-flex flex-wrap gap-1">
                                                                @if($subscription->breaking_news_enabled)
                                                                    <span class="badge bg-danger">Breaking News</span>
                                                                @endif
                                                                @if($subscription->daily_digest_enabled)
                                                                    <span class="badge bg-primary">Daily Digest</span>
                                                                @endif
                                                                @if($subscription->weekly_summary_enabled)
                                                                    <span class="badge bg-success">Weekly Summary</span>
                                                                @endif
                                                                @if($subscription->marketing_enabled)
                                                                    <span class="badge bg-warning">Marketing</span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h6>Timing Preferences</h6>
                                                            @if($subscription->quiet_hours_start && $subscription->quiet_hours_end)
                                                                <p><strong>Quiet Hours:</strong> {{ $subscription->quiet_hours_start }} - {{ $subscription->quiet_hours_end }}</p>
                                                            @endif
                                                            @if($subscription->preferred_days)
                                                                <p><strong>Preferred Days:</strong> {{ implode(', ', $subscription->preferred_days) }}</p>
                                                            @endif
                                                            @if($subscription->preferred_times)
                                                                <p><strong>Preferred Times:</strong> {{ implode(', ', $subscription->preferred_times) }}</p>
                                                            @endif
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h6>Activity</h6>
                                                            <p><strong>Subscribed:</strong> {{ $subscription->subscribed_at->format('M j, Y g:i A') }}</p>
                                                            <p><strong>Last Activity:</strong> {{ $subscription->last_activity_at ? $subscription->last_activity_at->format('M j, Y g:i A') : 'Never' }}</p>
                                                            <p><strong>Status:</strong> 
                                                                @if($subscription->is_active)
                                                                    <span class="badge bg-success">Active</span>
                                                                @else
                                                                    <span class="badge bg-secondary">Inactive</span>
                                                                @endif
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-users fa-3x mb-3"></i>
                                                <p>No subscriptions found.</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($subscriptions->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $subscriptions->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@section('title', 'Notification Subscriptions')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Notification Subscriptions</h1>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Campaigns
                </a>
            </div>

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_subscriptions']) }}</h4>
                                    <p class="card-text">Total Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-users fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['active_subscriptions']) }}</h4>
                                    <p class="card-text">Active Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-check-circle fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['web_subscriptions']) }}</h4>
                                    <p class="card-text">Web Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-desktop fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['mobile_subscriptions']) }}</h4>
                                    <p class="card-text">Mobile Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-mobile-alt fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">All Subscriptions</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Device</th>
                                    <th>Categories</th>
                                    <th>Preferences</th>
                                    <th>Status</th>
                                    <th>Last Activity</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($subscriptions as $subscription)
                                    <tr>
                                        <td>
                                            @if($subscription->user)
                                                <div>
                                                    <strong>{{ $subscription->user->name }}</strong>
                                                    <br>
                                                    <small class="text-muted">{{ $subscription->user->email }}</small>
                                                </div>
                                            @else
                                                <span class="text-muted">Guest User</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div>
                                                <span class="badge bg-info">{{ ucfirst($subscription->device_type ?? 'Unknown') }}</span>
                                                @if($subscription->browser)
                                                    <br>
                                                    <small class="text-muted">{{ $subscription->browser }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            @if($subscription->subscribed_categories)
                                                <div class="d-flex flex-wrap gap-1">
                                                    @foreach(array_slice($subscription->subscribed_categories, 0, 3) as $category)
                                                        <span class="badge bg-secondary">{{ ucfirst($category) }}</span>
                                                    @endforeach
                                                    @if(count($subscription->subscribed_categories) > 3)
                                                        <span class="badge bg-light text-dark">+{{ count($subscription->subscribed_categories) - 3 }}</span>
                                                    @endif
                                                </div>
                                            @else
                                                <span class="text-muted">All categories</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                @if($subscription->breaking_news_enabled)
                                                    <span class="badge bg-danger">Breaking</span>
                                                @endif
                                                @if($subscription->daily_digest_enabled)
                                                    <span class="badge bg-primary">Daily</span>
                                                @endif
                                                @if($subscription->weekly_summary_enabled)
                                                    <span class="badge bg-success">Weekly</span>
                                                @endif
                                                @if($subscription->marketing_enabled)
                                                    <span class="badge bg-warning">Marketing</span>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            @if($subscription->is_active)
                                                <span class="badge bg-success">Active</span>
                                            @else
                                                <span class="badge bg-secondary">Inactive</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($subscription->last_activity_at)
                                                {{ $subscription->last_activity_at->diffForHumans() }}
                                            @else
                                                <span class="text-muted">Never</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#subscriptionModal{{ $subscription->id }}">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                @if($subscription->is_active)
                                                    <form action="{{ route('admin.notifications.subscriptions') }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('PATCH')
                                                        <input type="hidden" name="subscription_id" value="{{ $subscription->id }}">
                                                        <input type="hidden" name="action" value="deactivate">
                                                        <button type="submit" class="btn btn-sm btn-outline-warning" onclick="return confirm('Are you sure you want to deactivate this subscription?')">
                                                            <i class="fas fa-pause"></i>
                                                        </button>
                                                    </form>
                                                @else
                                                    <form action="{{ route('admin.notifications.subscriptions') }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('PATCH')
                                                        <input type="hidden" name="subscription_id" value="{{ $subscription->id }}">
                                                        <input type="hidden" name="action" value="activate">
                                                        <button type="submit" class="btn btn-sm btn-outline-success" onclick="return confirm('Are you sure you want to activate this subscription?')">
                                                            <i class="fas fa-play"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>

                                    <!-- Subscription Details Modal -->
                                    <div class="modal fade" id="subscriptionModal{{ $subscription->id }}" tabindex="-1">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Subscription Details</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h6>User Information</h6>
                                                            @if($subscription->user)
                                                                <p><strong>Name:</strong> {{ $subscription->user->name }}</p>
                                                                <p><strong>Email:</strong> {{ $subscription->user->email }}</p>
                                                            @else
                                                                <p><strong>Type:</strong> Guest User</p>
                                                            @endif
                                                            <p><strong>Player ID:</strong> {{ $subscription->onesignal_player_id }}</p>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h6>Device Information</h6>
                                                            <p><strong>Device Type:</strong> {{ ucfirst($subscription->device_type ?? 'Unknown') }}</p>
                                                            <p><strong>Browser:</strong> {{ $subscription->browser ?? 'Unknown' }}</p>
                                                            <p><strong>OS:</strong> {{ $subscription->os ?? 'Unknown' }}</p>
                                                            <p><strong>Country:</strong> {{ $subscription->country ?? 'Unknown' }}</p>
                                                            <p><strong>Timezone:</strong> {{ $subscription->timezone ?? 'Unknown' }}</p>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h6>Subscribed Categories</h6>
                                                            @if($subscription->subscribed_categories)
                                                                <div class="d-flex flex-wrap gap-1">
                                                                    @foreach($subscription->subscribed_categories as $category)
                                                                        <span class="badge bg-secondary">{{ ucfirst($category) }}</span>
                                                                    @endforeach
                                                                </div>
                                                            @else
                                                                <p class="text-muted">All categories</p>
                                                            @endif
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h6>Notification Preferences</h6>
                                                            <div class="d-flex flex-wrap gap-1">
                                                                @if($subscription->breaking_news_enabled)
                                                                    <span class="badge bg-danger">Breaking News</span>
                                                                @endif
                                                                @if($subscription->daily_digest_enabled)
                                                                    <span class="badge bg-primary">Daily Digest</span>
                                                                @endif
                                                                @if($subscription->weekly_summary_enabled)
                                                                    <span class="badge bg-success">Weekly Summary</span>
                                                                @endif
                                                                @if($subscription->marketing_enabled)
                                                                    <span class="badge bg-warning">Marketing</span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h6>Timing Preferences</h6>
                                                            @if($subscription->quiet_hours_start && $subscription->quiet_hours_end)
                                                                <p><strong>Quiet Hours:</strong> {{ $subscription->quiet_hours_start }} - {{ $subscription->quiet_hours_end }}</p>
                                                            @endif
                                                            @if($subscription->preferred_days)
                                                                <p><strong>Preferred Days:</strong> {{ implode(', ', $subscription->preferred_days) }}</p>
                                                            @endif
                                                            @if($subscription->preferred_times)
                                                                <p><strong>Preferred Times:</strong> {{ implode(', ', $subscription->preferred_times) }}</p>
                                                            @endif
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h6>Activity</h6>
                                                            <p><strong>Subscribed:</strong> {{ $subscription->subscribed_at->format('M j, Y g:i A') }}</p>
                                                            <p><strong>Last Activity:</strong> {{ $subscription->last_activity_at ? $subscription->last_activity_at->format('M j, Y g:i A') : 'Never' }}</p>
                                                            <p><strong>Status:</strong> 
                                                                @if($subscription->is_active)
                                                                    <span class="badge bg-success">Active</span>
                                                                @else
                                                                    <span class="badge bg-secondary">Inactive</span>
                                                                @endif
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-users fa-3x mb-3"></i>
                                                <p>No subscriptions found.</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($subscriptions->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $subscriptions->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
