@extends('admin.layout')

@section('title', 'Notification Campaign Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Campaign Details</h1>
                <div>
                    <a href="{{ route('admin.notifications.edit', $notification) }}" class="btn btn-outline-primary">
                        <i class="fas fa-edit"></i> Edit Campaign
                    </a>
                    <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Campaigns
                    </a>
                </div>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-8">
                    <!-- Campaign Details -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Campaign Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <h4>{{ $notification->title }}</h4>
                                    <p class="text-muted mb-3">{{ $notification->message }}</p>
                                    
                                    @if($notification->action_url)
                                        <div class="mb-3">
                                            <strong>Action URL:</strong> 
                                            <a href="{{ $notification->action_url }}" target="_blank" class="text-decoration-none">
                                                {{ $notification->action_url }}
                                                <i class="fas fa-external-link-alt ms-1"></i>
                                            </a>
                                        </div>
                                    @endif

                                    @if($notification->action_text)
                                        <div class="mb-3">
                                            <strong>Action Button Text:</strong> {{ $notification->action_text }}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-4">
                                    @if($notification->image_url)
                                        <img src="{{ $notification->image_url }}" alt="Campaign image" class="img-fluid rounded">
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Targeting Information -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Targeting</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Target Audience</h6>
                                    <span class="badge bg-info">{{ ucfirst($notification->target_audience) }}</span>
                                </div>
                                <div class="col-md-6">
                                    <h6>Status</h6>
                                    @switch($notification->status)
                                        @case('draft')
                                            <span class="badge bg-secondary">Draft</span>
                                            @break
                                        @case('scheduled')
                                            <span class="badge bg-warning">Scheduled</span>
                                            @break
                                        @case('sent')
                                            <span class="badge bg-success">Sent</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">Cancelled</span>
                                            @break
                                    @endswitch
                                </div>
                            </div>

                            @if($notification->target_categories)
                                <div class="mt-3">
                                    <h6>Target Categories</h6>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($notification->target_categories as $category)
                                            <span class="badge bg-secondary">{{ ucfirst($category) }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            @if($notification->target_locations)
                                <div class="mt-3">
                                    <h6>Target Locations</h6>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($notification->target_locations as $location)
                                            <span class="badge bg-primary">{{ ucfirst($location) }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            @if($notification->target_interests)
                                <div class="mt-3">
                                    <h6>Target Interests</h6>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($notification->target_interests as $interest)
                                            <span class="badge bg-success">{{ ucfirst($interest) }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Notification Logs -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Notification Logs</h5>
                        </div>
                        <div class="card-body">
                            @if($logs->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>User</th>
                                                <th>Status</th>
                                                <th>Sent At</th>
                                                <th>Delivered At</th>
                                                <th>Clicked At</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($logs as $log)
                                                <tr>
                                                    <td>
                                                        @if($log->user)
                                                            <div>
                                                                <strong>{{ $log->user->name }}</strong>
                                                                <br>
                                                                <small class="text-muted">{{ $log->user->email }}</small>
                                                            </div>
                                                        @else
                                                            <span class="text-muted">Guest User</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @switch($log->status)
                                                            @case('sent')
                                                                <span class="badge bg-primary">Sent</span>
                                                                @break
                                                            @case('delivered')
                                                                <span class="badge bg-success">Delivered</span>
                                                                @break
                                                            @case('clicked')
                                                                <span class="badge bg-warning">Clicked</span>
                                                                @break
                                                            @case('converted')
                                                                <span class="badge bg-info">Converted</span>
                                                                @break
                                                            @case('failed')
                                                                <span class="badge bg-danger">Failed</span>
                                                                @break
                                                        @endswitch
                                                    </td>
                                                    <td>{{ $log->sent_at->format('M j, Y g:i A') }}</td>
                                                    <td>{{ $log->delivered_at ? $log->delivered_at->format('M j, Y g:i A') : '-' }}</td>
                                                    <td>{{ $log->clicked_at ? $log->clicked_at->format('M j, Y g:i A') : '-' }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                @if($logs->hasPages())
                                    <div class="d-flex justify-content-center">
                                        {{ $logs->links() }}
                                    </div>
                                @endif
                            @else
                                <div class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-list fa-3x mb-3"></i>
                                        <p>No notification logs found.</p>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <!-- Campaign Stats -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Campaign Statistics</h5>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6">
                                    <div class="stat-item">
                                        <h4 class="text-primary">{{ number_format($notification->sent_count) }}</h4>
                                        <small class="text-muted">Sent</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="stat-item">
                                        <h4 class="text-success">{{ number_format($notification->delivered_count) }}</h4>
                                        <small class="text-muted">Delivered</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="stat-item">
                                        <h4 class="text-warning">{{ number_format($notification->clicked_count) }}</h4>
                                        <small class="text-muted">Clicked</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="stat-item">
                                        <h4 class="text-info">{{ number_format($notification->converted_count) }}</h4>
                                        <small class="text-muted">Converted</small>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row text-center">
                                <div class="col-6">
                                    <small class="text-muted">Delivery Rate</small>
                                    <div class="fw-bold">{{ $notification->delivery_rate }}%</div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Click Rate</small>
                                    <div class="fw-bold">{{ $notification->click_rate }}%</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Campaign Actions -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                @if($notification->status === 'scheduled')
                                    <form action="{{ route('admin.notifications.send', $notification) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="btn btn-success w-100" onclick="return confirm('Are you sure you want to send this campaign?')">
                                            <i class="fas fa-paper-plane"></i> Send Now
                                        </button>
                                    </form>
                                @endif

                                @if($notification->status === 'scheduled')
                                    <form action="{{ route('admin.notifications.cancel', $notification) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="btn btn-warning w-100" onclick="return confirm('Are you sure you want to cancel this campaign?')">
                                            <i class="fas fa-times"></i> Cancel Campaign
                                        </button>
                                    </form>
                                @endif

                                @if($notification->status !== 'sent')
                                    <form action="{{ route('admin.notifications.destroy', $notification) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger w-100" onclick="return confirm('Are you sure you want to delete this campaign? This action cannot be undone.')">
                                            <i class="fas fa-trash"></i> Delete Campaign
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Campaign Details -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Campaign Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Created:</strong><br>
                                {{ $notification->created_at->format('M j, Y g:i A') }}
                            </div>

                            @if($notification->scheduled_at)
                                <div class="mb-3">
                                    <strong>Scheduled:</strong><br>
                                    {{ $notification->scheduled_at->format('M j, Y g:i A') }}
                                </div>
                            @endif

                            @if($notification->expires_at)
                                <div class="mb-3">
                                    <strong>Expires:</strong><br>
                                    {{ $notification->expires_at->format('M j, Y g:i A') }}
                                </div>
                            @endif

                            @if($notification->onesignal_campaign_id)
                                <div class="mb-3">
                                    <strong>OneSignal ID:</strong><br>
                                    <code>{{ $notification->onesignal_campaign_id }}</code>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@section('title', 'Notification Campaign Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Campaign Details</h1>
                <div>
                    <a href="{{ route('admin.notifications.edit', $notification) }}" class="btn btn-outline-primary">
                        <i class="fas fa-edit"></i> Edit Campaign
                    </a>
                    <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Campaigns
                    </a>
                </div>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-8">
                    <!-- Campaign Details -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Campaign Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <h4>{{ $notification->title }}</h4>
                                    <p class="text-muted mb-3">{{ $notification->message }}</p>
                                    
                                    @if($notification->action_url)
                                        <div class="mb-3">
                                            <strong>Action URL:</strong> 
                                            <a href="{{ $notification->action_url }}" target="_blank" class="text-decoration-none">
                                                {{ $notification->action_url }}
                                                <i class="fas fa-external-link-alt ms-1"></i>
                                            </a>
                                        </div>
                                    @endif

                                    @if($notification->action_text)
                                        <div class="mb-3">
                                            <strong>Action Button Text:</strong> {{ $notification->action_text }}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-4">
                                    @if($notification->image_url)
                                        <img src="{{ $notification->image_url }}" alt="Campaign image" class="img-fluid rounded">
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Targeting Information -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Targeting</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Target Audience</h6>
                                    <span class="badge bg-info">{{ ucfirst($notification->target_audience) }}</span>
                                </div>
                                <div class="col-md-6">
                                    <h6>Status</h6>
                                    @switch($notification->status)
                                        @case('draft')
                                            <span class="badge bg-secondary">Draft</span>
                                            @break
                                        @case('scheduled')
                                            <span class="badge bg-warning">Scheduled</span>
                                            @break
                                        @case('sent')
                                            <span class="badge bg-success">Sent</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">Cancelled</span>
                                            @break
                                    @endswitch
                                </div>
                            </div>

                            @if($notification->target_categories)
                                <div class="mt-3">
                                    <h6>Target Categories</h6>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($notification->target_categories as $category)
                                            <span class="badge bg-secondary">{{ ucfirst($category) }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            @if($notification->target_locations)
                                <div class="mt-3">
                                    <h6>Target Locations</h6>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($notification->target_locations as $location)
                                            <span class="badge bg-primary">{{ ucfirst($location) }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            @if($notification->target_interests)
                                <div class="mt-3">
                                    <h6>Target Interests</h6>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($notification->target_interests as $interest)
                                            <span class="badge bg-success">{{ ucfirst($interest) }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Notification Logs -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Notification Logs</h5>
                        </div>
                        <div class="card-body">
                            @if($logs->count() > 0)
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>User</th>
                                                <th>Status</th>
                                                <th>Sent At</th>
                                                <th>Delivered At</th>
                                                <th>Clicked At</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($logs as $log)
                                                <tr>
                                                    <td>
                                                        @if($log->user)
                                                            <div>
                                                                <strong>{{ $log->user->name }}</strong>
                                                                <br>
                                                                <small class="text-muted">{{ $log->user->email }}</small>
                                                            </div>
                                                        @else
                                                            <span class="text-muted">Guest User</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @switch($log->status)
                                                            @case('sent')
                                                                <span class="badge bg-primary">Sent</span>
                                                                @break
                                                            @case('delivered')
                                                                <span class="badge bg-success">Delivered</span>
                                                                @break
                                                            @case('clicked')
                                                                <span class="badge bg-warning">Clicked</span>
                                                                @break
                                                            @case('converted')
                                                                <span class="badge bg-info">Converted</span>
                                                                @break
                                                            @case('failed')
                                                                <span class="badge bg-danger">Failed</span>
                                                                @break
                                                        @endswitch
                                                    </td>
                                                    <td>{{ $log->sent_at->format('M j, Y g:i A') }}</td>
                                                    <td>{{ $log->delivered_at ? $log->delivered_at->format('M j, Y g:i A') : '-' }}</td>
                                                    <td>{{ $log->clicked_at ? $log->clicked_at->format('M j, Y g:i A') : '-' }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                @if($logs->hasPages())
                                    <div class="d-flex justify-content-center">
                                        {{ $logs->links() }}
                                    </div>
                                @endif
                            @else
                                <div class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-list fa-3x mb-3"></i>
                                        <p>No notification logs found.</p>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <!-- Campaign Stats -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Campaign Statistics</h5>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6">
                                    <div class="stat-item">
                                        <h4 class="text-primary">{{ number_format($notification->sent_count) }}</h4>
                                        <small class="text-muted">Sent</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="stat-item">
                                        <h4 class="text-success">{{ number_format($notification->delivered_count) }}</h4>
                                        <small class="text-muted">Delivered</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="stat-item">
                                        <h4 class="text-warning">{{ number_format($notification->clicked_count) }}</h4>
                                        <small class="text-muted">Clicked</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="stat-item">
                                        <h4 class="text-info">{{ number_format($notification->converted_count) }}</h4>
                                        <small class="text-muted">Converted</small>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row text-center">
                                <div class="col-6">
                                    <small class="text-muted">Delivery Rate</small>
                                    <div class="fw-bold">{{ $notification->delivery_rate }}%</div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Click Rate</small>
                                    <div class="fw-bold">{{ $notification->click_rate }}%</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Campaign Actions -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                @if($notification->status === 'scheduled')
                                    <form action="{{ route('admin.notifications.send', $notification) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="btn btn-success w-100" onclick="return confirm('Are you sure you want to send this campaign?')">
                                            <i class="fas fa-paper-plane"></i> Send Now
                                        </button>
                                    </form>
                                @endif

                                @if($notification->status === 'scheduled')
                                    <form action="{{ route('admin.notifications.cancel', $notification) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="btn btn-warning w-100" onclick="return confirm('Are you sure you want to cancel this campaign?')">
                                            <i class="fas fa-times"></i> Cancel Campaign
                                        </button>
                                    </form>
                                @endif

                                @if($notification->status !== 'sent')
                                    <form action="{{ route('admin.notifications.destroy', $notification) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger w-100" onclick="return confirm('Are you sure you want to delete this campaign? This action cannot be undone.')">
                                            <i class="fas fa-trash"></i> Delete Campaign
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Campaign Details -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Campaign Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Created:</strong><br>
                                {{ $notification->created_at->format('M j, Y g:i A') }}
                            </div>

                            @if($notification->scheduled_at)
                                <div class="mb-3">
                                    <strong>Scheduled:</strong><br>
                                    {{ $notification->scheduled_at->format('M j, Y g:i A') }}
                                </div>
                            @endif

                            @if($notification->expires_at)
                                <div class="mb-3">
                                    <strong>Expires:</strong><br>
                                    {{ $notification->expires_at->format('M j, Y g:i A') }}
                                </div>
                            @endif

                            @if($notification->onesignal_campaign_id)
                                <div class="mb-3">
                                    <strong>OneSignal ID:</strong><br>
                                    <code>{{ $notification->onesignal_campaign_id }}</code>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
