@extends('admin.layout')

@section('title', 'Notification Campaigns')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Notification Campaigns</h1>
                <div>
                    <a href="{{ route('admin.notifications.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Create Campaign
                    </a>
                    <a href="{{ route('admin.notifications.analytics') }}" class="btn btn-outline-primary">
                        <i class="fas fa-chart-bar"></i> Analytics
                    </a>
                    <a href="{{ route('admin.notifications.subscriptions') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-users"></i> Subscriptions
                    </a>
                </div>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Status</th>
                                    <th>Target Audience</th>
                                    <th>Scheduled</th>
                                    <th>Sent</th>
                                    <th>Delivered</th>
                                    <th>Clicked</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($campaigns as $campaign)
                                    <tr>
                                        <td>
                                            <div>
                                                <strong>{{ $campaign->title }}</strong>
                                                <br>
                                                <small class="text-muted">{{ Str::limit($campaign->message, 50) }}</small>
                                            </div>
                                        </td>
                                        <td>
                                            @switch($campaign->status)
                                                @case('draft')
                                                    <span class="badge bg-secondary">Draft</span>
                                                    @break
                                                @case('scheduled')
                                                    <span class="badge bg-warning">Scheduled</span>
                                                    @break
                                                @case('sent')
                                                    <span class="badge bg-success">Sent</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge bg-danger">Cancelled</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ ucfirst($campaign->target_audience) }}</span>
                                            @if($campaign->target_categories)
                                                <br>
                                                <small class="text-muted">
                                                    {{ implode(', ', array_slice($campaign->target_categories, 0, 2)) }}
                                                    @if(count($campaign->target_categories) > 2)
                                                        +{{ count($campaign->target_categories) - 2 }} more
                                                    @endif
                                                </small>
                                            @endif
                                        </td>
                                        <td>
                                            @if($campaign->scheduled_at)
                                                {{ $campaign->scheduled_at->format('M j, Y g:i A') }}
                                            @else
                                                <span class="text-muted">Not scheduled</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-primary">{{ number_format($campaign->sent_count) }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-success">{{ number_format($campaign->delivered_count) }}</span>
                                            @if($campaign->sent_count > 0)
                                                <br>
                                                <small class="text-muted">{{ $campaign->delivery_rate }}%</small>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-warning">{{ number_format($campaign->clicked_count) }}</span>
                                            @if($campaign->delivered_count > 0)
                                                <br>
                                                <small class="text-muted">{{ $campaign->click_rate }}%</small>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.notifications.show', $campaign) }}" class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($campaign->status !== 'sent')
                                                    <a href="{{ route('admin.notifications.edit', $campaign) }}" class="btn btn-sm btn-outline-secondary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                @endif
                                                @if($campaign->status === 'scheduled')
                                                    <form action="{{ route('admin.notifications.send', $campaign) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-outline-success" onclick="return confirm('Are you sure you want to send this campaign?')">
                                                            <i class="fas fa-paper-plane"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                                @if($campaign->status === 'scheduled')
                                                    <form action="{{ route('admin.notifications.cancel', $campaign) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-outline-warning" onclick="return confirm('Are you sure you want to cancel this campaign?')">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                                @if($campaign->status !== 'sent')
                                                    <form action="{{ route('admin.notifications.destroy', $campaign) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this campaign?')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-bell-slash fa-3x mb-3"></i>
                                                <p>No notification campaigns found.</p>
                                                <a href="{{ route('admin.notifications.create') }}" class="btn btn-primary">
                                                    Create Your First Campaign
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($campaigns->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $campaigns->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@section('title', 'Notification Campaigns')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Notification Campaigns</h1>
                <div>
                    <a href="{{ route('admin.notifications.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Create Campaign
                    </a>
                    <a href="{{ route('admin.notifications.analytics') }}" class="btn btn-outline-primary">
                        <i class="fas fa-chart-bar"></i> Analytics
                    </a>
                    <a href="{{ route('admin.notifications.subscriptions') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-users"></i> Subscriptions
                    </a>
                </div>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Status</th>
                                    <th>Target Audience</th>
                                    <th>Scheduled</th>
                                    <th>Sent</th>
                                    <th>Delivered</th>
                                    <th>Clicked</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($campaigns as $campaign)
                                    <tr>
                                        <td>
                                            <div>
                                                <strong>{{ $campaign->title }}</strong>
                                                <br>
                                                <small class="text-muted">{{ Str::limit($campaign->message, 50) }}</small>
                                            </div>
                                        </td>
                                        <td>
                                            @switch($campaign->status)
                                                @case('draft')
                                                    <span class="badge bg-secondary">Draft</span>
                                                    @break
                                                @case('scheduled')
                                                    <span class="badge bg-warning">Scheduled</span>
                                                    @break
                                                @case('sent')
                                                    <span class="badge bg-success">Sent</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge bg-danger">Cancelled</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ ucfirst($campaign->target_audience) }}</span>
                                            @if($campaign->target_categories)
                                                <br>
                                                <small class="text-muted">
                                                    {{ implode(', ', array_slice($campaign->target_categories, 0, 2)) }}
                                                    @if(count($campaign->target_categories) > 2)
                                                        +{{ count($campaign->target_categories) - 2 }} more
                                                    @endif
                                                </small>
                                            @endif
                                        </td>
                                        <td>
                                            @if($campaign->scheduled_at)
                                                {{ $campaign->scheduled_at->format('M j, Y g:i A') }}
                                            @else
                                                <span class="text-muted">Not scheduled</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-primary">{{ number_format($campaign->sent_count) }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-success">{{ number_format($campaign->delivered_count) }}</span>
                                            @if($campaign->sent_count > 0)
                                                <br>
                                                <small class="text-muted">{{ $campaign->delivery_rate }}%</small>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-warning">{{ number_format($campaign->clicked_count) }}</span>
                                            @if($campaign->delivered_count > 0)
                                                <br>
                                                <small class="text-muted">{{ $campaign->click_rate }}%</small>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.notifications.show', $campaign) }}" class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($campaign->status !== 'sent')
                                                    <a href="{{ route('admin.notifications.edit', $campaign) }}" class="btn btn-sm btn-outline-secondary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                @endif
                                                @if($campaign->status === 'scheduled')
                                                    <form action="{{ route('admin.notifications.send', $campaign) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-outline-success" onclick="return confirm('Are you sure you want to send this campaign?')">
                                                            <i class="fas fa-paper-plane"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                                @if($campaign->status === 'scheduled')
                                                    <form action="{{ route('admin.notifications.cancel', $campaign) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-outline-warning" onclick="return confirm('Are you sure you want to cancel this campaign?')">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                                @if($campaign->status !== 'sent')
                                                    <form action="{{ route('admin.notifications.destroy', $campaign) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this campaign?')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-bell-slash fa-3x mb-3"></i>
                                                <p>No notification campaigns found.</p>
                                                <a href="{{ route('admin.notifications.create') }}" class="btn btn-primary">
                                                    Create Your First Campaign
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($campaigns->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $campaigns->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
