@extends('admin.layout')

@section('title', 'Notification Analytics')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Notification Analytics</h1>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Campaigns
                </a>
            </div>

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_campaigns']) }}</h4>
                                    <p class="card-text">Total Campaigns</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-bullhorn fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_subscriptions']) }}</h4>
                                    <p class="card-text">Active Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-users fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_delivered']) }}</h4>
                                    <p class="card-text">Total Delivered</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-check-circle fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_clicked']) }}</h4>
                                    <p class="card-text">Total Clicks</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-mouse-pointer fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Campaigns -->
            <div class="row">
                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Recent Campaigns</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Campaign</th>
                                            <th>Status</th>
                                            <th>Sent</th>
                                            <th>Delivered</th>
                                            <th>Clicked</th>
                                            <th>Rate</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($recentCampaigns as $campaign)
                                            <tr>
                                                <td>
                                                    <div>
                                                        <strong>{{ $campaign->title }}</strong>
                                                        <br>
                                                        <small class="text-muted">{{ $campaign->created_at->format('M j, Y g:i A') }}</small>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge bg-success">Sent</span>
                                                </td>
                                                <td>{{ number_format($campaign->sent_count) }}</td>
                                                <td>{{ number_format($campaign->delivered_count) }}</td>
                                                <td>{{ number_format($campaign->clicked_count) }}</td>
                                                <td>
                                                    @if($campaign->delivered_count > 0)
                                                        {{ round(($campaign->clicked_count / $campaign->delivered_count) * 100, 1) }}%
                                                    @else
                                                        0%
                                                    @endif
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center py-4">
                                                    <div class="text-muted">
                                                        <i class="fas fa-chart-line fa-3x mb-3"></i>
                                                        <p>No campaigns sent yet.</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Top Performing Campaigns</h5>
                        </div>
                        <div class="card-body">
                            @forelse($topCampaigns as $index => $campaign)
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h6 class="mb-1">{{ $campaign->title }}</h6>
                                        <small class="text-muted">{{ $campaign->clicked_count }} clicks</small>
                                    </div>
                                    <div class="text-end">
                                        <span class="badge bg-primary">#{{ $index + 1 }}</span>
                                    </div>
                                </div>
                            @empty
                                <div class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-trophy fa-3x mb-3"></i>
                                        <p>No performance data yet.</p>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Quick Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="{{ route('admin.notifications.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create New Campaign
                                </a>
                                <a href="{{ route('admin.notifications.subscriptions') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-users"></i> Manage Subscriptions
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@section('title', 'Notification Analytics')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Notification Analytics</h1>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left"></i> Back to Campaigns
                </a>
            </div>

            <!-- Stats Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_campaigns']) }}</h4>
                                    <p class="card-text">Total Campaigns</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-bullhorn fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_subscriptions']) }}</h4>
                                    <p class="card-text">Active Subscriptions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-users fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_delivered']) }}</h4>
                                    <p class="card-text">Total Delivered</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-check-circle fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title">{{ number_format($stats['total_clicked']) }}</h4>
                                    <p class="card-text">Total Clicks</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-mouse-pointer fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Campaigns -->
            <div class="row">
                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Recent Campaigns</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Campaign</th>
                                            <th>Status</th>
                                            <th>Sent</th>
                                            <th>Delivered</th>
                                            <th>Clicked</th>
                                            <th>Rate</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($recentCampaigns as $campaign)
                                            <tr>
                                                <td>
                                                    <div>
                                                        <strong>{{ $campaign->title }}</strong>
                                                        <br>
                                                        <small class="text-muted">{{ $campaign->created_at->format('M j, Y g:i A') }}</small>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge bg-success">Sent</span>
                                                </td>
                                                <td>{{ number_format($campaign->sent_count) }}</td>
                                                <td>{{ number_format($campaign->delivered_count) }}</td>
                                                <td>{{ number_format($campaign->clicked_count) }}</td>
                                                <td>
                                                    @if($campaign->delivered_count > 0)
                                                        {{ round(($campaign->clicked_count / $campaign->delivered_count) * 100, 1) }}%
                                                    @else
                                                        0%
                                                    @endif
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center py-4">
                                                    <div class="text-muted">
                                                        <i class="fas fa-chart-line fa-3x mb-3"></i>
                                                        <p>No campaigns sent yet.</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Top Performing Campaigns</h5>
                        </div>
                        <div class="card-body">
                            @forelse($topCampaigns as $index => $campaign)
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h6 class="mb-1">{{ $campaign->title }}</h6>
                                        <small class="text-muted">{{ $campaign->clicked_count }} clicks</small>
                                    </div>
                                    <div class="text-end">
                                        <span class="badge bg-primary">#{{ $index + 1 }}</span>
                                    </div>
                                </div>
                            @empty
                                <div class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-trophy fa-3x mb-3"></i>
                                        <p>No performance data yet.</p>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Quick Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="{{ route('admin.notifications.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create New Campaign
                                </a>
                                <a href="{{ route('admin.notifications.subscriptions') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-users"></i> Manage Subscriptions
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
