@extends('admin.layout')

@section('title', 'Dashboard')

@section('content')
<div class="admin-header">
    <h1 class="mb-0">
        <i class="fas fa-tachometer-alt"></i> Admin Dashboard
    </h1>
    <p class="text-muted mb-0">Manage your Mews AI chatbot and monitor performance</p>
</div>

<!-- Statistics Cards -->
<div class="row">
    <div class="col-md-3">
        <div class="stats-card">
            <div class="stats-number">{{ $stats['total_ads'] }}</div>
            <div class="stats-label">Total Ads</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="stats-number">{{ $stats['active_ads'] }}</div>
            <div class="stats-label">Active Ads</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="stats-number">{{ number_format($stats['total_impressions']) }}</div>
            <div class="stats-label">Total Impressions</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="stats-number">{{ number_format($stats['total_clicks']) }}</div>
            <div class="stats-label">Total Clicks</div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row">
    <div class="col-md-6">
        <div class="admin-card">
            <h5><i class="fas fa-plus-circle"></i> Quick Actions</h5>
            <div class="d-grid gap-2">
                <a href="{{ route('admin.ads.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create New Ad
                </a>
                <a href="{{ route('admin.settings') }}" class="btn btn-outline-primary">
                    <i class="fas fa-cog"></i> Configure AI Settings
                </a>
                <a href="{{ route('admin.branding') }}" class="btn btn-outline-primary">
                    <i class="fas fa-palette"></i> Customize Branding
                </a>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="admin-card">
            <h5><i class="fas fa-chart-line"></i> Performance Overview</h5>
            @if($stats['total_impressions'] > 0)
                <div class="mb-3">
                    <strong>Click-Through Rate:</strong>
                    <div class="progress mt-2">
                        <div class="progress-bar bg-success" style="width: {{ ($stats['total_clicks'] / $stats['total_impressions']) * 100 }}%">
                            {{ number_format(($stats['total_clicks'] / $stats['total_impressions']) * 100, 2) }}%
                        </div>
                    </div>
                </div>
            @endif
            
            <div class="row text-center">
                <div class="col-6">
                    <div class="border-end">
                        <h6 class="text-muted">Avg. Display Time</h6>
                        <h4 class="text-primary">1.5s</h4>
                    </div>
                </div>
                <div class="col-6">
                    <h6 class="text-muted">Active Campaigns</h6>
                    <h4 class="text-success">{{ $stats['active_ads'] }}</h4>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Ads -->
<div class="admin-card">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5><i class="fas fa-ad"></i> Recent Ads</h5>
        <a href="{{ route('admin.ads') }}" class="btn btn-outline-primary btn-sm">View All</a>
    </div>
    
    @if($recent_ads->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Ad</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Impressions</th>
                        <th>Clicks</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recent_ads as $ad)
                    <tr>
                        <td>
                            <div>
                                <strong>{{ $ad->title }}</strong>
                                <br>
                                <small class="text-muted">{{ Str::limit($ad->content, 50) }}</small>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-info">{{ ucfirst($ad->media_type) }}</span>
                        </td>
                        <td>
                            @if($ad->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>{{ number_format($ad->current_impressions) }}</td>
                        <td>{{ number_format($ad->clicks) }}</td>
                        <td>{{ \Carbon\Carbon::parse($ad->created_at)->diffForHumans() }}</td>
                        <td>
                            <a href="{{ route('admin.ads.edit', $ad->id) }}" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-edit"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <div class="text-center py-4">
            <i class="fas fa-ad fa-3x text-muted mb-3"></i>
            <h6 class="text-muted">No ads created yet</h6>
            <p class="text-muted">Create your first ad to start monetizing your chatbot</p>
            <a href="{{ route('admin.ads.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create First Ad
            </a>
        </div>
    @endif
</div>

<!-- System Status -->
<div class="admin-card">
    <h5><i class="fas fa-server"></i> System Status</h5>
    <div class="row">
        <div class="col-md-3">
            <div class="text-center">
                <i class="fas fa-robot fa-2x text-success mb-2"></i>
                <h6>Chatbot Status</h6>
                <span class="badge bg-success">Online</span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="text-center">
                <i class="fas fa-database fa-2x text-info mb-2"></i>
                <h6>Database</h6>
                <span class="badge bg-success">Connected</span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="text-center">
                <i class="fas fa-brain fa-2x text-warning mb-2"></i>
                <h6>AI Service</h6>
                <span class="badge bg-success">Active</span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="text-center">
                <i class="fas fa-upload fa-2x text-primary mb-2"></i>
                <h6>File Storage</h6>
                <span class="badge bg-success">Ready</span>
            </div>
        </div>
    </div>
</div>
@endsection
