"use strict";

exports.__esModule = true;
exports.default = qsa;
const toArray = Function.prototype.bind.call(Function.prototype.call, [].slice);

/**
 * Runs `querySelectorAll` on a given element.
 *
 * @param element the element
 * @param selector the selector
 */
function qsa(element, selector) {
  return toArray(element.querySelectorAll(selector));
}
module.exports = exports.default;