<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Chatbot Settings
        $chatbotSettings = [
            // AI Settings
            ['setting_key' => 'ai_temperature', 'setting_value' => '0.2', 'setting_type' => 'float', 'description' => 'AI response creativity level (0.0 = conservative, 2.0 = creative)', 'category' => 'ai'],
            ['setting_key' => 'ai_max_tokens', 'setting_value' => '150', 'setting_type' => 'integer', 'description' => 'Maximum tokens for AI responses', 'category' => 'ai'],
            ['setting_key' => 'ai_model', 'setting_value' => 'gpt-4-turbo', 'setting_type' => 'string', 'description' => 'OpenAI model to use for responses', 'category' => 'ai'],
            ['setting_key' => 'ai_response_speed', 'setting_value' => 'balanced', 'setting_type' => 'string', 'description' => 'Balance between response quality and speed', 'category' => 'ai'],
            
            // UI Settings
            ['setting_key' => 'ui_theme', 'setting_value' => 'auto', 'setting_type' => 'string', 'description' => 'Default UI theme (light, dark, auto)', 'category' => 'ui'],
            ['setting_key' => 'ui_animations', 'setting_value' => 'true', 'setting_type' => 'boolean', 'description' => 'Enable UI animations', 'category' => 'ui'],
            ['setting_key' => 'ui_compact_mode', 'setting_value' => 'false', 'setting_type' => 'boolean', 'description' => 'Enable compact UI mode', 'category' => 'ui'],
            
            // Behavior Settings
            ['setting_key' => 'auto_scroll', 'setting_value' => 'true', 'setting_type' => 'boolean', 'description' => 'Auto-scroll to new messages', 'category' => 'behavior'],
            ['setting_key' => 'typing_indicator', 'setting_value' => 'true', 'setting_type' => 'boolean', 'description' => 'Show typing indicator', 'category' => 'behavior'],
            ['setting_key' => 'message_sound', 'setting_value' => 'false', 'setting_type' => 'boolean', 'description' => 'Play sound for new messages', 'category' => 'behavior'],
        ];

        // Branding Settings
        $brandingSettings = [
            // Color Settings
            ['setting_key' => 'primary_color', 'setting_value' => '#0a57d4', 'setting_type' => 'color', 'description' => 'Primary brand color', 'category' => 'colors'],
            ['setting_key' => 'secondary_color', 'setting_value' => '#2d72f0', 'setting_type' => 'color', 'description' => 'Secondary brand color', 'category' => 'colors'],
            ['setting_key' => 'accent_color', 'setting_value' => '#5a95ff', 'setting_type' => 'color', 'description' => 'Accent color for highlights', 'category' => 'colors'],
            ['setting_key' => 'text_color', 'setting_value' => '#333333', 'setting_type' => 'color', 'description' => 'Primary text color', 'category' => 'colors'],
            ['setting_key' => 'background_color', 'setting_value' => '#ffffff', 'setting_type' => 'color', 'description' => 'Main background color', 'category' => 'colors'],
            
            // Image Settings
            ['setting_key' => 'logo_url', 'setting_value' => '', 'setting_type' => 'image_url', 'description' => 'Company logo URL', 'category' => 'images'],
            ['setting_key' => 'favicon_url', 'setting_value' => '', 'setting_type' => 'image_url', 'description' => 'Favicon URL', 'category' => 'images'],
            ['setting_key' => 'hero_image_url', 'setting_value' => '', 'setting_type' => 'image_url', 'description' => 'Hero section background image', 'category' => 'images'],
            
            // Text Settings
            ['setting_key' => 'company_name', 'setting_value' => 'NewsBot', 'setting_type' => 'string', 'description' => 'Company/brand name', 'category' => 'text'],
            ['setting_key' => 'tagline', 'setting_value' => 'Your AI-Powered News Assistant', 'setting_type' => 'string', 'description' => 'Company tagline', 'category' => 'text'],
            ['setting_key' => 'welcome_message', 'setting_value' => 'Hello! I\'m your AI news assistant. Ask me about any topic!', 'setting_type' => 'string', 'description' => 'Welcome message for users', 'category' => 'text'],
        ];

        // Insert chatbot settings
        foreach ($chatbotSettings as $setting) {
            DB::table('chatbot_settings')->insert(array_merge($setting, [
                'is_editable' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }

        // Insert branding settings
        foreach ($brandingSettings as $setting) {
            DB::table('branding_settings')->insert(array_merge($setting, [
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}


