<?php

namespace Database\Seeders;

use App\Models\Election\Region;
use App\Models\Election\RegionCensus;
use Illuminate\Database\Seeder;

class RegionCensusSeeder extends Seeder
{
    /**
     * Seed 2021 census from regions.population (Ghana PHC 2021).
     * Run election:census-import for 2000/2010 from JSON when available.
     */
    public function run(): void
    {
        $regions = Region::all();
        foreach ($regions as $region) {
            if ($region->population !== null && $region->population > 0) {
                RegionCensus::updateOrCreate(
                    ['census_year' => 2021, 'region_id' => $region->id],
                    ['population' => $region->population]
                );
            }
        }
        $this->command->info('Seeded 2021 census from regions.');
    }
}
