<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('region_census', function (Blueprint $table) {
            $table->id();
            $table->unsignedSmallInteger('census_year'); // 2000, 2010, 2021
            $table->foreignId('region_id')->constrained('regions')->onDelete('cascade');
            $table->unsignedBigInteger('population')->nullable();
            $table->timestamps();

            $table->unique(['census_year', 'region_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('region_census');
    }
};
