<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('query_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->string('session_id')->nullable(); // For anonymous users
            $table->text('query');
            $table->string('intent')->nullable(); // news_search, general_chat, article_request, etc.
            $table->json('response_data')->nullable(); // AI response data
            $table->integer('response_time_ms')->nullable();
            $table->integer('tokens_used')->nullable();
            $table->string('model_used')->nullable();
            $table->boolean('was_successful')->default(true);
            $table->string('error_message')->nullable();
            $table->string('user_ip')->nullable();
            $table->string('user_agent')->nullable();
            $table->string('referrer')->nullable();
            $table->json('context_data')->nullable(); // Additional context about the query
            $table->timestamp('created_at');
            
            $table->index(['user_id', 'created_at']);
            $table->index(['session_id', 'created_at']);
            $table->index(['intent', 'created_at']);
            $table->index(['created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('query_logs');
    }
};