<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_bookmarks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('article_id'); // ID from vw_crawler_mews
            $table->string('article_title');
            $table->string('article_category')->nullable();
            $table->string('article_source')->nullable();
            $table->text('notes')->nullable();
            $table->json('tags')->nullable(); // JSON array of tags
            $table->boolean('is_favorite')->default(false);
            $table->timestamp('bookmarked_at')->useCurrent();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_bookmarks');
    }
};
