<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Insert the ad_frequency setting if it doesn't exist
        DB::table('ai_settings')->insertOrIgnore([
            'setting_key' => 'ad_frequency',
            'setting_value' => 'every',
            'setting_type' => 'string',
            'description' => 'Controls how often ads are displayed to users',
            'category' => 'ui',
            'created_at' => now(),
            'updated_at' => now()
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('ai_settings')->where('setting_key', 'ad_frequency')->delete();
    }
};
