<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ai_ads', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('content');
            $table->string('label')->default('Sponsored'); // Sponsored, Premium, Featured, etc.
            $table->string('cta_text');
            $table->string('cta_url');
            $table->string('media_type')->default('text'); // text, image, video
            $table->string('media_url')->nullable(); // URL for image/video
            $table->string('media_alt')->nullable(); // Alt text for media
            $table->integer('display_duration')->default(1500); // milliseconds
            $table->integer('rotation_weight')->default(1); // Higher weight = more frequent display
            $table->json('targeting_rules')->nullable(); // JSON for targeting (page, user type, etc.)
            $table->boolean('is_active')->default(true);
            $table->timestamp('start_date')->nullable();
            $table->timestamp('end_date')->nullable();
            $table->integer('max_impressions')->nullable(); // Limit total impressions
            $table->integer('current_impressions')->default(0);
            $table->integer('clicks')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ai_ads');
    }
};
