<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;

class RegionCensus extends Model
{
    protected $table = 'region_census';

    protected $fillable = ['census_year', 'region_id', 'population'];

    protected $casts = [
        'census_year' => 'integer',
        'population' => 'integer',
    ];

    public function region()
    {
        return $this->belongsTo(Region::class);
    }
}
