<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Region extends Model
{
    protected $fillable = [
        'name',
        'code',
        'population',
        'registered_voters',
    ];

    protected $casts = [
        'population' => 'integer',
        'registered_voters' => 'integer',
    ];

    public function constituencies(): HasMany
    {
        return $this->hasMany(Constituency::class);
    }

    public function electionResults(): HasMany
    {
        return $this->hasMany(ElectionResultRegional::class);
    }

    /**
     * Get election results for a specific election year
     */
    public function getResultsForElection(int $electionId)
    {
        return $this->electionResults()
            ->where('election_id', $electionId)
            ->with('party', 'candidate')
            ->get();
    }

    /**
     * Get the winning party in a specific election
     */
    public function getWinnerForElection(int $electionId)
    {
        return $this->electionResults()
            ->where('election_id', $electionId)
            ->where('is_region_winner', true)
            ->with('party')
            ->first();
    }
}
