<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ParliamentarySeat extends Model
{
    protected $fillable = [
        'election_id',
        'party_id',
        'seats_won',
        'percentage',
    ];

    protected $casts = [
        'seats_won' => 'integer',
        'percentage' => 'decimal:2',
    ];

    public function election(): BelongsTo
    {
        return $this->belongsTo(Election::class);
    }

    public function party(): BelongsTo
    {
        return $this->belongsTo(Party::class);
    }

    /**
     * Check if this party has majority
     */
    public function getHasMajorityAttribute(): bool
    {
        // Ghana Parliament has 275 seats, majority is 138
        return $this->seats_won >= 138;
    }
}
