<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ElectionResultRegional extends Model
{
    protected $table = 'election_results_regional';

    protected $fillable = [
        'election_id',
        'region_id',
        'candidate_id',
        'party_id',
        'votes',
        'percentage',
        'total_votes_in_region',
        'is_region_winner',
    ];

    protected $casts = [
        'votes' => 'integer',
        'percentage' => 'decimal:2',
        'total_votes_in_region' => 'integer',
        'is_region_winner' => 'boolean',
    ];

    public function election(): BelongsTo
    {
        return $this->belongsTo(Election::class);
    }

    public function region(): BelongsTo
    {
        return $this->belongsTo(Region::class);
    }

    public function candidate(): BelongsTo
    {
        return $this->belongsTo(Candidate::class);
    }

    public function party(): BelongsTo
    {
        return $this->belongsTo(Party::class);
    }

    /**
     * Get the vote margin over the second place
     */
    public function getMarginAttribute(): ?int
    {
        if (!$this->is_region_winner) {
            return null;
        }

        $secondPlace = self::where('election_id', $this->election_id)
            ->where('region_id', $this->region_id)
            ->where('id', '!=', $this->id)
            ->orderByDesc('votes')
            ->first();

        return $secondPlace ? $this->votes - $secondPlace->votes : $this->votes;
    }
}
