<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ElectionResultNational extends Model
{
    protected $table = 'election_results_national';

    protected $fillable = [
        'election_id',
        'candidate_id',
        'party_id',
        'votes',
        'percentage',
        'is_winner',
    ];

    protected $casts = [
        'votes' => 'integer',
        'percentage' => 'decimal:2',
        'is_winner' => 'boolean',
    ];

    public function election(): BelongsTo
    {
        return $this->belongsTo(Election::class);
    }

    public function candidate(): BelongsTo
    {
        return $this->belongsTo(Candidate::class);
    }

    public function party(): BelongsTo
    {
        return $this->belongsTo(Party::class);
    }
}
