<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ElectionResultConstituency extends Model
{
    protected $table = 'election_results_constituency';

    protected $fillable = [
        'election_id',
        'constituency_id',
        'candidate_id',
        'party_id',
        'votes',
        'percentage',
        'total_votes_in_constituency',
        'is_constituency_winner',
    ];

    protected $casts = [
        'votes' => 'integer',
        'percentage' => 'decimal:2',
        'total_votes_in_constituency' => 'integer',
        'is_constituency_winner' => 'boolean',
    ];

    public function election(): BelongsTo
    {
        return $this->belongsTo(Election::class);
    }

    public function constituency(): BelongsTo
    {
        return $this->belongsTo(Constituency::class);
    }

    public function candidate(): BelongsTo
    {
        return $this->belongsTo(Candidate::class);
    }

    public function party(): BelongsTo
    {
        return $this->belongsTo(Party::class);
    }
}
