<?php

namespace App\Models\Election;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;

class ElectionChatLog extends Model
{
    protected $fillable = [
        'user_id',
        'session_id',
        'query',
        'response',
        'intent',
        'context_data',
        'data_sources_used',
        'response_time_ms',
        'was_successful',
        'error_message',
        'user_ip',
        'user_agent',
    ];

    protected $casts = [
        'context_data' => 'json',
        'data_sources_used' => 'json',
        'response_time_ms' => 'integer',
        'was_successful' => 'boolean',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Scope for successful queries
     */
    public function scopeSuccessful($query)
    {
        return $query->where('was_successful', true);
    }

    /**
     * Scope for failed queries
     */
    public function scopeFailed($query)
    {
        return $query->where('was_successful', false);
    }

    /**
     * Scope by intent type
     */
    public function scopeByIntent($query, string $intent)
    {
        return $query->where('intent', $intent);
    }
}
