<?php

namespace App\Console\Commands;

use App\Services\OneSignalService;
use Illuminate\Console\Command;

class SendBreakingNews extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notifications:breaking-news {title} {message} {--url=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send breaking news notification to subscribed users';

    /**
     * Execute the console command.
     */
    public function handle(OneSignalService $oneSignalService)
    {
        $title = $this->argument('title');
        $message = $this->argument('message');
        $url = $this->option('url');

        $this->info("Sending breaking news: {$title}");

        try {
            $result = $oneSignalService->sendBreakingNews($title, $message, $url);

            if ($result) {
                $this->info('Breaking news notification sent successfully!');
                return Command::SUCCESS;
            } else {
                $this->error('Failed to send breaking news notification.');
                return Command::FAILURE;
            }
        } catch (\Exception $e) {
            $this->error('Error sending breaking news: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}