<?php

namespace App\Console\Commands;

use App\Models\Election\Election;
use App\Services\PeaceFm2020ScraperService;
use Illuminate\Console\Command;

class ScrapePeaceFm2020 extends Command
{
    protected $signature = 'election:scrape-peacefm-2020 {--page=all : president|swing|marginal|regional|all}';
    protected $description = 'Scrape 2020 Ghana Presidential election data from Peace FM (ghanaelections.peacefmonline.com)';

    public function handle(PeaceFm2020ScraperService $scraper): int
    {
        $election = Election::where('year', 2020)->where('type', 'presidential')->first();
        if (!$election) {
            $this->error('2020 presidential election not found. Run: php artisan db:seed --class=ElectionDataSeeder');
            return self::FAILURE;
        }

        $page = $this->option('page');
        $this->info('Scraping Peace FM 2020 President data...');

        if ($page === 'all' || $page === 'president') {
            $this->info('Fetching president page...');
            $r = $scraper->scrapePresidentPage($election);
            $this->line($r['success'] ? '  OK: national + regional' : '  Failed: ' . ($r['error'] ?? 'unknown'));
        }
        if ($page === 'all' || $page === 'swing') {
            $this->info('Fetching swing constituencies...');
            $r = $scraper->scrapeSwingPage($election);
            $this->line($r['success'] ? '  OK' : '  Failed: ' . ($r['error'] ?? 'unknown'));
        }
        if ($page === 'all' || $page === 'marginal') {
            $this->info('Fetching marginal wins...');
            $r = $scraper->scrapeMarginalPage($election);
            $this->line($r['success'] ? '  OK' : '  Failed: ' . ($r['error'] ?? 'unknown'));
        }
        if ($page === 'all' || $page === 'regional') {
            $this->info('Fetching regional analysis...');
            $r = $scraper->scrapeRegionalAnalysisPage($election);
            $this->line($r['success'] ? '  OK' : '  Failed: ' . ($r['error'] ?? 'unknown'));
        }

        $this->info('Done. View 2020 President on /elections?year=2020&type=presidential');
        return self::SUCCESS;
    }
}
