<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CleanupSessions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sessions:cleanup {--days=7 : Number of days to keep sessions}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean up expired and old sessions from the database';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $days = $this->option('days');
        $cutoffTime = now()->subDays($days)->timestamp;
        
        // Delete expired sessions
        $expiredCount = DB::table('sessions')
            ->where('last_activity', '<', $cutoffTime)
            ->delete();
            
        $this->info("Cleaned up {$expiredCount} expired sessions older than {$days} days.");
        
        // Also clean up sessions that are past their lifetime
        $lifetime = config('session.lifetime', 120);
        $lifetimeCutoff = now()->subMinutes($lifetime)->timestamp;
        
        $lifetimeCount = DB::table('sessions')
            ->where('last_activity', '<', $lifetimeCutoff)
            ->delete();
            
        $this->info("Cleaned up {$lifetimeCount} sessions past their lifetime ({$lifetime} minutes).");
        
        // Show current session count
        $currentCount = DB::table('sessions')->count();
        $this->info("Current active sessions: {$currentCount}");
        
        return 0;
    }
}