// User Types
export interface User {
  id: number;
  name: string;
  email: string;
  created_at: string;
}

// Chat Types
export interface ChatMessage {
  id: string;
  text: string;
  isUser: boolean;
  timestamp: Date;
  intent?: string;
  newsData?: NewsArticle[]; // Keep for backward compatibility
  news_data?: NewsArticle[]; // Add correct field name from API
}

export interface ChatResponse {
  success: boolean;
  response: string;
  news_data: NewsArticle[];
  query_analysis: {
    intent_type: string;
    category?: string;
    keywords?: string[];
    location?: string;
  };
  is_news_query: boolean;
}

// News Types
export interface NewsArticle {
  id: number;
  title: string;
  category: string;
  sub_category: string;
  content: string;
  date: string;
  source: string;
  image: string;
  views: number;
}

// API Types
export interface ApiResponse<T> {
  success: boolean;
  data?: T;
  error?: string;
  message?: string;
}

// Navigation Types
export type RootStackParamList = {
  Main: undefined;
  Profile: undefined;
  Discover: undefined;
  DeepDive: { article: NewsArticle };
};

export type TabParamList = {
  Home: undefined;
  Chat: undefined;
  Profile: undefined;
};

// Redux Types
export interface AppState {
  user: User | null;
  chat: {
    messages: ChatMessage[];
    isLoading: boolean;
  };
  news: {
    articles: NewsArticle[];
    isLoading: boolean;
    categories: string[];
  };
}
