import { createConfig } from '@gluestack-ui/themed';

export const config = createConfig({
  aliases: {
    bg: 'backgroundColor',
    bgColor: 'backgroundColor',
    rounded: 'borderRadius',
  },
  tokens: {
    colors: {
      primary: {
        50: '#eff6ff',
        100: '#dbeafe',
        200: '#bfdbfe',
        300: '#93c5fd',
        400: '#60a5fa',
        500: '#3b82f6',
        600: '#2563eb',
        700: '#1d4ed8',
        800: '#1e40af',
        900: '#1e3a8a',
        950: '#172554',
      },
    },
    space: {
      px: '1px',
      0: 0,
      0.5: 2,
      1: 4,
      1.5: 6,
      2: 8,
      2.5: 10,
      3: 12,
      3.5: 14,
      4: 16,
      5: 20,
      6: 24,
      7: 28,
      8: 32,
      9: 36,
      10: 40,
      12: 48,
      16: 64,
      20: 80,
      24: 96,
      32: 128,
      40: 160,
      48: 192,
      56: 224,
      64: 256,
      72: 288,
      80: 320,
      96: 384,
    },
    borderWidths: {
      0: 0,
      1: 1,
      2: 2,
      4: 4,
      8: 8,
    },
    radii: {
      none: 0,
      xs: 2,
      sm: 4,
      md: 6,
      lg: 8,
      xl: 12,
      '2xl': 16,
      '3xl': 24,
      full: 9999,
    },
    fontSizes: {
      '2xs': 10,
      xs: 12,
      sm: 14,
      md: 16,
      lg: 18,
      xl: 20,
      '2xl': 24,
      '3xl': 30,
      '4xl': 36,
      '5xl': 48,
      '6xl': 60,
      '7xl': 72,
      '8xl': 96,
      '9xl': 128,
    },
    fontWeights: {
      hairline: '100',
      thin: '200',
      light: '300',
      normal: '400',
      medium: '500',
      semibold: '600',
      bold: '700',
      extrabold: '800',
      black: '900',
    },
    lineHeights: {
      '2xs': 16,
      xs: 18,
      sm: 20,
      md: 22,
      lg: 28,
      xl: 28,
      '2xl': 32,
      '3xl': 40,
      '4xl': 44,
      '5xl': 56,
      '6xl': 72,
      '7xl': 90,
      '8xl': 110,
      '9xl': 128,
    },
    letterSpacings: {
      xs: -0.4,
      sm: -0.2,
      md: 0,
      lg: 0.2,
      xl: 0.4,
      '2xl': 0.6,
      '3xl': 0.8,
      '4xl': 1,
      '5xl': 1.2,
      '6xl': 1.4,
      '7xl': 1.6,
      '8xl': 1.8,
      '9xl': 2,
    },
  },
});

// Extend the internal config
type ConfigType = typeof config;

declare module '@gluestack-ui/themed' {
  interface ICustomConfig extends ConfigType {}
}