# 🚀 LIVE SERVER DEPLOYMENT GUIDE

## 📋 PRE-DEPLOYMENT CHECKLIST

### 1. 🔧 Environment Configuration (.env)

Update your live server's `.env` file with these settings:

```env
# App Configuration
APP_NAME="Mews AI"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://mewsai.fumbo.ai

# Database Configuration (Update with your live server details)
DB_CONNECTION=mysql
DB_HOST=your_live_db_host
DB_PORT=3306
DB_DATABASE=your_live_db_name
DB_USERNAME=your_live_db_user
DB_PASSWORD=your_live_db_password

# Crawler Database Configuration
CRAWLER_DB_HOST=your_live_db_host
CRAWLER_DB_PORT=3306
CRAWLER_DB_DATABASE=crawl
CRAWLER_DB_USERNAME=your_live_db_user
CRAWLER_DB_PASSWORD=your_live_db_password

# Storage Configuration (CRITICAL FOR IMAGES)
FILESYSTEM_DISK=public
STORAGE_URL=/storage

# Session Configuration
SESSION_DRIVER=database
SESSION_LIFETIME=480
SESSION_ENCRYPT=true
SESSION_SECURE_COOKIE=true
SESSION_HTTP_ONLY=true
SESSION_SAME_SITE=lax

# Cache Configuration
CACHE_STORE=database
CACHE_PREFIX=mews_cache_
```

### 2. 📁 File Permissions

Set proper permissions on your live server:

```bash
# Set directory permissions
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
chmod -R 755 public/

# Set file permissions
chmod -R 644 storage/app/public/
```

### 3. 🔗 Storage Symlink

**CRITICAL:** Create the storage symlink on your live server:

```bash
# Navigate to your project root
cd /path/to/your/mews/project

# Create the storage symlink
php artisan storage:link

# Verify the symlink exists
ls -la public/storage
# Should show: public/storage -> ../storage/app/public
```

### 4. 🗄️ Database Setup

Run these commands on your live server:

```bash
# Run migrations
php artisan migrate --force

# Clear and cache config
php artisan config:clear
php artisan config:cache
php artisan route:clear
php artisan route:cache
php artisan view:clear
php artisan view:cache

# Clear all caches
php artisan cache:clear
php artisan session:clear
```

### 5. 🖼️ Image Storage Fix

If images are still broken after deployment:

```bash
# Check if symlink exists
ls -la public/storage

# If symlink doesn't exist, recreate it
rm -rf public/storage
php artisan storage:link

# Check storage directory permissions
ls -la storage/app/public/

# Ensure web server can read files
chmod -R 755 storage/app/public/
```

## 🔍 TROUBLESHOOTING

### Broken Images
1. **Check symlink**: `ls -la public/storage`
2. **Check permissions**: `ls -la storage/app/public/`
3. **Check .env**: Ensure `STORAGE_URL=/storage`
4. **Check APP_URL**: Must match your domain

### Database Connection Issues
1. **Check credentials**: Verify DB_HOST, DB_USERNAME, DB_PASSWORD
2. **Check database exists**: Ensure the database is created
3. **Check user permissions**: Database user needs full access

### Session Issues
1. **Check SESSION_DRIVER**: Should be `database`
2. **Run migrations**: Ensure sessions table exists
3. **Check SESSION_SECURE_COOKIE**: Set to `true` for HTTPS

## 📞 SUPPORT

If you encounter issues:
1. Check Laravel logs: `storage/logs/laravel.log`
2. Check web server error logs
3. Verify file permissions and symlinks
4. Test database connectivity

---

**Remember to update your live server's .env file with the correct database credentials and domain!**
